package com.crazyxk.dta;

import android.app.Activity;
import android.app.Application;
import android.app.Application.ActivityLifecycleCallbacks;
import android.content.Context;

import androidx.annotation.NonNull;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager.FragmentLifecycleCallbacks;

import com.crazyxk.dta.base.delegate.AppLifecycle;
import com.crazyxk.dta.di.module.ConfigModule;

import java.util.List;

/**
 * {@link DtaModule} 为 DTA 配置参数， 需要实现 {@link DtaModule} 后，在 AndroidManifest 中声明使用该实现类
 *
 * @author Feng Chen
 */
public interface DtaModule {

    /**
     * 使用 {@link ConfigModule.Builder} 给 DTA 配置一些配置参数
     *
     * @param context
     * @param builder
     */
    void applyOptions(@NonNull Context context, @NonNull ConfigModule.Builder builder);

    /**
     * 使用 {@link AppLifecycle} 在 {@link Application} 的生命周期中注入一些操作
     *
     * @param context
     * @param lifecycles
     */
    void injectAppLifecycle(@NonNull Context context, @NonNull List<AppLifecycle> lifecycles);

    /**
     * 使用 {@link ActivityLifecycleCallbacks} 在 {@link Activity} 的生命周期中注入一些操作
     *
     * @param context
     * @param lifecycles
     */
    void injectActivityLifecycle(@NonNull Context context, @NonNull List<ActivityLifecycleCallbacks> lifecycles);

    /**
     * 使用 {@link FragmentLifecycleCallbacks} 在 {@link Fragment} 的生命周期中注入一些操作
     *
     * @param context
     * @param lifecycles
     */
    void injectFragmentLifecycle(@NonNull Context context, @NonNull List<FragmentLifecycleCallbacks> lifecycles);

}
