package com.crazyxk.dta;

import android.content.Context;

import androidx.annotation.NonNull;

import com.crazyxk.dta.mvp.DtaModel;

/**
 * 用来管理网络请求以及数据缓存
 * 提供给 {@link DtaModel} 层必要的 Api 做业务处理
 */
public interface IRepositoryManager {

    /**
     * 根据传入的 Class 获取对应的 Retrofit service
     *
     * @param service
     * @param <T>
     * @return
     */
    @NonNull
    <T> T obtainRetrofitService(@NonNull Class<T> service);

    /**
     * 根据传入的 Class 获取对应的 RxCache service
     *
     * @param cache
     * @param <T>
     * @return
     */
    <T> T obtainCacheService(@NonNull Class<T> cache);

    /**
     * 清除所有缓存
     */
    void clearAllCache();

    /**
     * 获取 {@link Context}
     *
     * @return
     */
    @NonNull
    Context getContext();

}
