package com.crazyxk.dta.base;

import android.app.Application;
import android.content.Context;

import androidx.annotation.NonNull;

import com.crazyxk.dta.base.delegate.AppDelegate;
import com.crazyxk.dta.base.delegate.AppLifecycle;
import com.crazyxk.dta.di.component.AppComponent;

/**
 * @author Feng Chen
 */
public class DtaApplication extends Application implements App {

    private AppLifecycle mAppDelegate;

    @NonNull
    @Override
    public AppComponent getAppComponent() {
        return ((App) mAppDelegate).getAppComponent();
    }

    @Override
    protected void attachBaseContext(Context base) {
        super.attachBaseContext(base);
        if (mAppDelegate == null) {
            mAppDelegate = new AppDelegate(base);
        }
        mAppDelegate.attachBaseContext(base);
    }

    @Override
    public void onCreate() {
        super.onCreate();
        if (mAppDelegate != null) {
            mAppDelegate.onCreate(this);
        }
    }

    @Override
    public void onTerminate() {
        super.onTerminate();
        if (mAppDelegate != null) {
            mAppDelegate.onTerminate(this);
        }
    }
}
