package com.crazyxk.dta.base.delegate;

import android.app.Activity;
import android.os.Bundle;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.crazyxk.dta.eventbus.EventBusManager;
import com.crazyxk.dta.util.DtaUtil;


/**
 * @author Feng Chen
 */
public class ActivityDelegateImpl implements ActivityDelegate {

    private Activity mActivity;
    private IActivity iActivity;

    public ActivityDelegateImpl(Activity activity) {
        mActivity = activity;
        this.iActivity = (IActivity) activity;
    }

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        // 使用 EventBus
        if (iActivity.useEventBus()) {
            // 注册到事件主线
            EventBusManager.getInstance().register(mActivity);
        }

        // 提供 AppComponent 对象给 DtaActivity 的子类
        iActivity.setupActivityComponent(DtaUtil.obtainAppComponentFromContext(mActivity));

    }

    @Override
    public void onStart() {

    }

    @Override
    public void onResume() {

    }

    @Override
    public void onPause() {

    }

    @Override
    public void onStop() {

    }

    @Override
    public void onSaveInstanceState(@NonNull Bundle outState) {

    }

    @Override
    public void onDestroy() {
        // 使用 EventBus
        if (iActivity != null && iActivity.useEventBus()) {
            EventBusManager.getInstance().unregister(mActivity);
        }

        this.iActivity = null;
        this.mActivity = null;
    }
}
