package com.crazyxk.dta.base.delegate;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;

import com.crazyxk.dta.di.component.AppComponent;
import com.crazyxk.dta.cache.Cache;

/**
 * DTA 要求 {@link Fragment} 都需要实现 IFragment
 *
 * @author Feng Chen
 */
public interface IFragment {

    /**
     * 提供在 {@link Fragment} 生命周期内的缓存容器, 可向此 {@link Fragment} 存取一些必要的数据
     * 此缓存容器和 {@link Fragment} 的生命周期绑定, 如果 {@link Fragment} 在屏幕旋转或者配置更改的情况下
     * 重新创建, 那此缓存容器中的数据也会被清空
     *
     * @return
     */
    @NonNull
    Cache<String, Object> provideCache();

    /**
     * 提供 AppComponent (提供所有的单例对象) 给实现类, 进行 Component 依赖
     *
     * @param appComponent
     */
    void setupFragmentComponent(AppComponent appComponent);

    /**
     * 是否使用 EventBus
     *
     * @return
     */
    boolean useEventBus();

    /**
     * c初始化 View
     *
     * @param inflater
     * @param container
     * @param savedInstanceState
     * @return
     */
    View initView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState);

    /**
     * 初始化数据
     *
     * @param savedInstanceState
     */
    void initData(@NonNull Bundle savedInstanceState);

    /**
     * 通过此方法可以使 Fragment 能够与外界做一些交互和通信
     *
     * @param data
     */
    void setData(@NonNull Object data);


}
