package com.crazyxk.dta.di.module;

import android.app.Application;
import android.app.Application.ActivityLifecycleCallbacks;
import android.content.Context;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentManager.FragmentLifecycleCallbacks;

import com.crazyxk.dta.base.ActivityLifecycle;
import com.crazyxk.dta.base.AppManager;
import com.crazyxk.dta.base.FragmentLifecycle;
import com.crazyxk.dta.IRepositoryManager;
import com.crazyxk.dta.RepositoryManager;
import com.crazyxk.dta.cache.Cache;
import com.crazyxk.dta.cache.CacheType;
import com.crazyxk.dta.rxlifecycle.RxActivityLifecycle;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;

import java.util.ArrayList;
import java.util.List;

import javax.inject.Named;
import javax.inject.Singleton;

import dagger.Binds;
import dagger.Module;
import dagger.Provides;

/**
 * @author Feng Chen
 */
@Module
public abstract class AppModule {

    @Singleton
    @Provides
    static Gson provideGson(Application application, @Nullable GsonConfiguration configuration) {
        GsonBuilder builder = new GsonBuilder();
        if (configuration != null) {
            configuration.configGson(application, builder);
        }
        return builder.create();
    }

    @Singleton
    @Provides
    static AppManager provideAppManager(Application application) {
        return AppManager.getAppManager().init(application);
    }

    @Binds
    abstract IRepositoryManager bindRepositoryManager(RepositoryManager repositoryManager);

    @Singleton
    @Provides
    static Cache<String, Object> provideExtras(Cache.Factory cacheFactory) {
        return cacheFactory.build(CacheType.EXTRAS);
    }

    @Binds
    @Named("ActivityLifecycle")
    abstract ActivityLifecycleCallbacks bindActivityLifecycle(ActivityLifecycle activityLifecycle);

    @Binds
    @Named("RxActivityLifecycle")
    abstract ActivityLifecycleCallbacks bindRxActivityLifecycle(RxActivityLifecycle rxActivityLifecycle);

    @Binds
    abstract FragmentLifecycleCallbacks bindFragmentLifecycle(FragmentLifecycle fragmentLifecycle);

    @Singleton
    @Provides
    static List<FragmentManager.FragmentLifecycleCallbacks> provideFragmentLifecycles() {
        return new ArrayList<>();
    }

    ////////////////////////////////////////////////////////////////////

    public interface GsonConfiguration {

        void configGson(@NonNull Context context, @NonNull GsonBuilder builder);

    }

}
