package com.crazyxk.dta.imageloader;

import android.content.Context;

import androidx.annotation.Nullable;

/**
 * 图片加载策略
 * 实现 {@link BaseImageLoaderStrategy} 并通过 {@link ImageLoader#setLoadImageStrategy(BaseImageLoaderStrategy)} 配置后
 *
 * @author Feng Chen
 */
public interface BaseImageLoaderStrategy<T extends ImageConfig> {

    /**
     * 加载图片
     *
     * @param context
     * @param config
     */
    void loadImage(@Nullable Context context, @Nullable T config);

    /**
     * 停止加载
     *
     * @param context
     * @param config
     */
    void clear(@Nullable Context context, @Nullable T config);

}
