package com.crazyxk.dta.imageloader;

import android.content.Context;

import androidx.annotation.Nullable;

import com.crazyxk.dta.util.Preconditions;

import javax.inject.Inject;
import javax.inject.Singleton;

/**
 * {@link ImageLoader} 可以动态切换图片请求框架
 *
 * @author Feng Chen
 */
@Singleton
public class ImageLoader {

    @Inject
    @Nullable
    BaseImageLoaderStrategy mStrategy;

    @Inject
    public ImageLoader() {

    }

    public <T extends ImageConfig> void loadImage(Context context, T config) {
        Preconditions.checkNotNull(mStrategy,
                "Please implement BaseImageLoaderStrategy " +
                        "and call ConfigModule.Builder#imageLoaderStrategy(BaseImageLoaderStrategy) " +
                        "in the applyOptions method of DtaModule"
        );
        mStrategy.loadImage(context, config);
    }

    public <T extends ImageConfig> void clear(Context context, T config) {
        Preconditions.checkNotNull(mStrategy,
                "Please implement BaseImageLoaderStrategy " +
                        "and call ConfigModule.Builder#imageLoaderStrategy(BaseImageLoaderStrategy) " +
                        "in the applyOptions method of DtaModule"
        );
        mStrategy.clear(context, config);
    }

    /**
     * 可在运行期 切换 {@link BaseImageLoaderStrategy}
     *
     * @param strategy
     */
    public void setLoadImageStrategy(BaseImageLoaderStrategy strategy) {
        Preconditions.checkNotNull(strategy, "strategy == null");
        mStrategy = strategy;
    }

    @Nullable
    public BaseImageLoaderStrategy getLoadImageStrategy() {
        return mStrategy;
    }
}
