package com.crazyxk.dta.mvp;

import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.OnLifecycleEvent;

import com.crazyxk.dta.IRepositoryManager;

/**
 * Model 基类
 *
 * @author Feng Chen
 */
public class BaseDtaModel implements DtaModel, LifecycleObserver {

    protected IRepositoryManager mRepositoryManager;

    public BaseDtaModel(IRepositoryManager repositoryManager) {
        mRepositoryManager = repositoryManager;
    }

    @Override
    public void onDestroy() {
        mRepositoryManager = null;
    }

    @OnLifecycleEvent(Lifecycle.Event.ON_DESTROY)
    void onDestory(LifecycleOwner owner) {
        owner.getLifecycle().removeObserver(this);
    }

}
