package com.crazyxk.dta.mvp;

import android.app.Activity;
import android.content.Intent;

import androidx.annotation.NonNull;

import com.crazyxk.dta.util.DtaUtil;

import static com.crazyxk.dta.util.Preconditions.checkNotNull;

/**
 * DTA 要求每个 View 都要事先 DtaView
 *
 * @author Feng Chen
 */
public interface DtaView {

    /**
     * 显示加载
     */
    default void showLoading() {

    }

    /**
     * 隐藏加载
     */
    default void hideLoading() {

    }

    /**
     * 显示信息
     *
     * @param message
     */
    void showMessage(@NonNull String message);

    /**
     * 跳转 {@link Activity}
     *
     * @param intent
     */
    default void launchActivity(@NonNull Intent intent) {
        checkNotNull(intent);
        DtaUtil.startActivity(intent);
    }

}
