package com.crazyxk.dta.rxlifecycle;

import android.app.Activity;

import androidx.annotation.NonNull;
import androidx.fragment.app.Fragment;

import com.trello.rxlifecycle2.RxLifecycle;

import io.reactivex.subjects.Subject;

/**
 * 让 {@link Activity}/{@link Fragment} 实现此接口,即可正常使用 {@link RxLifecycle}
 * 无需继承 {@link RxLifecycle} 提供的 Activity/Fragment
 *
 * @author Feng Chen
 */
public interface Lifecycleable<E> {

    @NonNull
    Subject<E> provideLifecycleSubject();

}
