package com.crazyxk.dta.widget;

import android.view.View;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import static com.crazyxk.dta.util.AutoUtil.autoSize;
import static com.crazyxk.dta.util.ThirdViewUtil.bindTarget;
import static com.crazyxk.dta.util.ThirdViewUtil.isUseAutolayout;

/**
 * @author Feng Chen
 */
public abstract class BaseHolder<T> extends RecyclerView.ViewHolder implements View.OnClickListener {

    protected OnViewClickListener mOnViewClickListener = null;

    public BaseHolder(@NonNull View itemView) {
        super(itemView);

        // 点击事件
        itemView.setOnClickListener(this);

        if (isUseAutolayout()) {
            autoSize(itemView);
        }

        // 绑定 ButterKnife
        bindTarget(this, itemView);
    }

    /**
     * 设置数据
     *
     * @param data     数据
     * @param position 在 RecyclerView 中的位置
     */
    public abstract void setData(@NonNull T data, int position);

    /**
     * 在 Activity 的 onDestroy 中使用 {@link DefaultAdapter#releaseAllHolder(RecyclerView)} 方法 (super.onDestroy() 之前)
     * {@link BaseHolder#onRelease()} 才会被调用, 可以在此方法中释放一些资源
     */
    protected void onRelease() {

    }

    @Override
    public void onClick(View v) {
        if (mOnViewClickListener != null) {
            mOnViewClickListener.onViewClick(v, getPosition());
        }
    }

    public void setOnItemClickListener(OnViewClickListener listener) {
        this.mOnViewClickListener = listener;
    }

    /**
     * item 点击事件
     */
    public interface OnViewClickListener {

        /**
         * item 被点击
         *
         * @param view     被点击的 {@link View}
         * @param position 在 RecyclerView 中的位置
         */
        void onViewClick(View view, int position);
    }

}
