/*
 * Decompiled with CFR 0.152.
 */
package com.cssw.bootx.apidoc.util;

import com.cssw.bootx.core.enums.BaseEnum;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springdoc.core.models.GroupedOpenApi;
import org.springframework.web.bind.annotation.RestController;

public class ApiDocUtils {
    public static GroupedOpenApi buildGroupedOpenApi(String group, String ... pathsToMatch) {
        return ApiDocUtils.buildGroupedOpenApi(group, group, pathsToMatch);
    }

    public static GroupedOpenApi buildGroupedOpenApi(String group, String displayName, String ... pathsToMatch) {
        return GroupedOpenApi.builder().group(group).displayName(displayName).pathsToMatch(pathsToMatch).build();
    }

    public static String getEnumValueTypeAsString(Class<?> enumClass) {
        Type[] interfaces = enumClass.getGenericInterfaces();
        Map<Class<String>, String> typeMap = Map.of(Integer.class, "integer", Long.class, "long", Double.class, "number", String.class, "string");
        for (Type type : interfaces) {
            Type actualType;
            ParameterizedType parameterizedType;
            if (!(type instanceof ParameterizedType) || (parameterizedType = (ParameterizedType)type).getRawType() != BaseEnum.class || !((actualType = parameterizedType.getActualTypeArguments()[0]) instanceof Class)) continue;
            Class actualClass = (Class)actualType;
            return typeMap.getOrDefault(actualClass, "string");
        }
        return "string";
    }

    public static String resolveFormat(String enumValueType) {
        return switch (enumValueType) {
            case "integer" -> "int32";
            case "long" -> "int64";
            case "number" -> "double";
            default -> enumValueType;
        };
    }

    public static boolean hasRestControllerAnnotation(Class<?> clazz) {
        if (clazz.isAnnotationPresent(RestController.class)) {
            return true;
        }
        for (Class<?> superClass = clazz.getSuperclass(); superClass != null && !superClass.equals(Object.class); superClass = superClass.getSuperclass()) {
            if (!ApiDocUtils.hasRestControllerAnnotation(superClass)) continue;
            return true;
        }
        return false;
    }

    public static Map<Object, String> getDescMap(Class<?> enumClass) {
        BaseEnum[] enums = (BaseEnum[])enumClass.getEnumConstants();
        return Arrays.stream(enums).collect(Collectors.toMap(BaseEnum::getValue, BaseEnum::getDescription, (a, b) -> a, LinkedHashMap::new));
    }

    @Generated
    private ApiDocUtils() {
    }
}

