/*
 * Decompiled with CFR 0.152.
 */
package com.cssw.bootx.auth.satoken.autoconfigure;

import cn.dev33.satoken.interceptor.SaInterceptor;
import cn.dev33.satoken.jwt.StpLogicJwtForSimple;
import cn.dev33.satoken.router.SaRouter;
import cn.dev33.satoken.stp.StpLogic;
import cn.dev33.satoken.stp.StpUtil;
import cn.hutool.extra.spring.SpringUtil;
import com.cssw.bootx.auth.satoken.autoconfigure.SaTokenExtensionProperties;
import com.cssw.bootx.auth.satoken.autoconfigure.dao.SaTokenDaoConfiguration;
import com.cssw.bootx.core.yaml.YamlPropertySourceFactory;
import jakarta.annotation.PostConstruct;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.PropertySource;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@AutoConfiguration
@EnableConfigurationProperties(value={SaTokenExtensionProperties.class})
@ConditionalOnProperty(prefix="sa-token.extension", name={"enabled"}, havingValue="true")
@PropertySource(value={"classpath:default-auth-satoken.yml"}, factory=YamlPropertySourceFactory.class)
public class SaTokenAutoConfiguration
implements WebMvcConfigurer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SaTokenAutoConfiguration.class);
    private final SaTokenExtensionProperties properties;

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)SpringUtil.getBean(SaInterceptor.class)).addPathPatterns(new String[]{"/**"}).order(-2147483448);
    }

    @Bean
    @ConditionalOnMissingBean
    public SaInterceptor saInterceptor() {
        return new SaInterceptor(handle -> SaRouter.match((String[])new String[]{"/**"}).notMatch(this.properties.getSecurity().getExcludes()).check(r -> StpUtil.checkLogin()));
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="sa-token.extension", name={"enableJwt"}, havingValue="true")
    public StpLogic stpLogic() {
        return new StpLogicJwtForSimple();
    }

    @PostConstruct
    public void postConstruct() {
        log.debug("[Bootx Starter] - Auto Configuration 'SaToken' completed initialization.");
    }

    @Generated
    public SaTokenAutoConfiguration(SaTokenExtensionProperties properties) {
        this.properties = properties;
    }

    @Configuration
    @Import(value={SaTokenDaoConfiguration.Default.class, SaTokenDaoConfiguration.Redis.class, SaTokenDaoConfiguration.Custom.class})
    protected static class SaTokenDaoAutoConfiguration {
        protected SaTokenDaoAutoConfiguration() {
        }
    }
}

