/*
 * Decompiled with CFR 0.152.
 */
package com.cssw.bootx.license.service;

import cn.hutool.core.util.IdUtil;
import com.cssw.bootx.license.exception.LicenseException;
import com.cssw.bootx.license.manager.ServerLicenseManager;
import com.cssw.bootx.license.model.BuildCreatorResp;
import com.cssw.bootx.license.model.ConfigParam;
import com.cssw.bootx.license.model.CustomKeyStoreParam;
import com.cssw.bootx.license.model.LicenseCreatorParam;
import com.cssw.bootx.license.model.LicenseCreatorParamVO;
import com.cssw.bootx.license.model.LicenseExtraModel;
import com.cssw.bootx.license.util.ExecCmdUtil;
import com.cssw.bootx.license.util.ServerInfoUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.schlichtherle.license.CipherParam;
import de.schlichtherle.license.DefaultCipherParam;
import de.schlichtherle.license.DefaultLicenseParam;
import de.schlichtherle.license.KeyStoreParam;
import de.schlichtherle.license.LicenseContent;
import de.schlichtherle.license.LicenseParam;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.prefs.Preferences;
import javax.security.auth.x500.X500Principal;
import lombok.Generated;
import net.lingala.zip4j.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseCreateService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LicenseCreateService.class);
    private static volatile LicenseCreateService instance;
    private static final X500Principal DEFAULT_HOLDER_ISSUER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LicenseCreateService getInstance() {
        if (instance != null) return instance;
        Class<LicenseCreateService> clazz = LicenseCreateService.class;
        synchronized (LicenseCreateService.class) {
            if (instance != null) return instance;
            instance = new LicenseCreateService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public LicenseExtraModel getServerInfo() {
        return ServerInfoUtils.getServerInfos();
    }

    public void generateLicense(LicenseCreatorParamVO paramVO) throws Exception {
        BuildCreatorResp buildCreatorResp = this.buildCreator(paramVO);
        LicenseCreatorParam param = buildCreatorResp.getParam();
        ZipFile clientZipFile = buildCreatorResp.getClientZipFile();
        try {
            LicenseParam licenseParam = this.initLicenseParam(param);
            ServerLicenseManager licenseManager = new ServerLicenseManager(licenseParam);
            LicenseContent licenseContent = this.initLicenseContent(param);
            licenseManager.store(licenseContent, new File(param.getLicensePath()));
            log.info("{} \u8bc1\u4e66\u751f\u6210\u6210\u529f \u8def\u5f84: {}", (Object)param.getSubject(), (Object)param.getLicensePath());
            clientZipFile.addFile(param.getLicensePath());
        }
        catch (Exception e) {
            throw new LicenseException("\u751f\u6210\u8bc1\u4e66\u5931\u8d25:" + param.getSubject(), (Throwable)e);
        }
    }

    private BuildCreatorResp buildCreator(LicenseCreatorParamVO paramVO) throws Exception {
        String customerName = paramVO.getCustomerName();
        String privateAlias = customerName + "-private-alias";
        String publicAlias = customerName + "-public-alias";
        String currentCustomerDir = this.relativePath(paramVO) + customerName + IdUtil.fastSimpleUUID() + File.separator;
        File customerDirFile = new File(currentCustomerDir);
        if (!customerDirFile.exists() && !customerDirFile.mkdirs()) {
            throw new IOException("Failed to create directory: " + currentCustomerDir);
        }
        String privateKeystore = currentCustomerDir + "privateKeys.keystore";
        String publicKeystore = currentCustomerDir + "publicCerts.keystore";
        String certFilePath = currentCustomerDir + "certfile.cer";
        String licensePath = currentCustomerDir + "license.lic";
        LicenseCreatorParam param = new LicenseCreatorParam();
        param.setSubject(customerName);
        param.setPrivateAlias(privateAlias);
        param.setKeyPass(paramVO.getKeyPass());
        param.setStorePass(paramVO.getStorePass());
        param.setLicensePath(licensePath);
        param.setPrivateKeysStorePath(privateKeystore);
        param.setExpiryTime(paramVO.getExpireTime());
        param.setDescription(paramVO.getDescription());
        param.setLicenseExtraModel(paramVO.getLicenseExtraModel());
        int validity = this.getValidity(param.getIssuedTime(), paramVO.getExpireTime());
        String dname = "\"CN=localhost, OU=localhost, O=localhost, L=SH, ST=SH, C=CN\"";
        String keyAlgOption = this.checkJavaVersion() ? "-keyalg DSA" : "";
        String genKeyCmd = String.format("keytool -genkeypair %s -keysize 1024 -validity %d -alias %s -keystore %s -storepass %s -keypass %s -dname %s", keyAlgOption, validity, privateAlias, privateKeystore, paramVO.getStorePass(), paramVO.getKeyPass(), dname);
        String exportCertCmd = String.format("keytool -exportcert -alias %s -keystore %s -storepass %s -file \"%s\"", privateAlias, privateKeystore, paramVO.getStorePass(), certFilePath);
        String importCertCmd = String.format("keytool -noprompt -import -alias %s -file \"%s\" -keystore %s -storepass %s", publicAlias, certFilePath, publicKeystore, paramVO.getStorePass());
        ExecCmdUtil.exec((String[])new String[]{genKeyCmd});
        ExecCmdUtil.exec((String[])new String[]{exportCertCmd});
        ExecCmdUtil.exec((String[])new String[]{importCertCmd});
        ZipFile clientZipFile = this.generateClientConfig(param, currentCustomerDir, publicAlias);
        return new BuildCreatorResp(param, clientZipFile);
    }

    private boolean checkJavaVersion() throws Exception {
        String version = System.getProperty("java.version");
        int currentVersion = 0;
        currentVersion = version.startsWith("1.") ? Integer.parseInt(version.split("\\.")[1]) : Integer.parseInt(version.split("\\.")[0]);
        return currentVersion >= 17;
    }

    private ZipFile generateClientConfig(LicenseCreatorParam param, String currentCustomerDir, String publicAlias) throws Exception {
        ZipFile clientLicense = new ZipFile(currentCustomerDir + "clientLicense.zip");
        File config = new File(currentCustomerDir + "clientConfig.json");
        ConfigParam configParam = new ConfigParam();
        configParam.setPublicAlias(publicAlias);
        configParam.setStorePass(param.getStorePass());
        configParam.setSubject(param.getSubject());
        ObjectMapper mapper = new ObjectMapper();
        String json = mapper.writeValueAsString((Object)configParam);
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(config);
            out.write(json.getBytes(StandardCharsets.UTF_8));
            out.flush();
        }
        catch (Exception e) {
            throw new LicenseException("\u5bc6\u94a5\u6587\u4ef6\u751f\u6210\u5931\u8d25", (Throwable)e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    throw new LicenseException("\u6587\u4ef6\u6d41\u5173\u95ed\u5931\u8d25", (Throwable)e);
                }
            }
        }
        ArrayList<File> files = new ArrayList<File>();
        files.add(config);
        files.add(new File(currentCustomerDir + "publicCerts.keystore"));
        clientLicense.addFiles(files);
        return clientLicense;
    }

    private int getValidity(Date issuedTime, Date expireTime) {
        long issued = issuedTime.getTime();
        long expire = expireTime.getTime();
        long differ = expire - issued;
        long remaining = differ % 86400000L;
        long validity = differ / 86400000L;
        if (remaining > 0L) {
            ++validity;
        }
        return (int)validity;
    }

    private boolean isWindows() {
        String os = System.getProperty("os.name");
        return os.toLowerCase().contains("windows");
    }

    private String relativePath(LicenseCreatorParamVO paramVO) {
        if (paramVO.getLicenseSavePath() != null) {
            return paramVO.getLicenseSavePath();
        }
        if (this.isWindows()) {
            return "C:/license/";
        }
        return "/data/license/";
    }

    private LicenseParam initLicenseParam(LicenseCreatorParam param) {
        Preferences preferences = Preferences.userNodeForPackage(LicenseCreateService.class);
        DefaultCipherParam cipherParam = new DefaultCipherParam(param.getStorePass());
        CustomKeyStoreParam privateStoreParam = new CustomKeyStoreParam(LicenseCreateService.class, param.getPrivateKeysStorePath(), param.getPrivateAlias(), param.getStorePass(), param.getKeyPass());
        return new DefaultLicenseParam(param.getSubject(), preferences, (KeyStoreParam)privateStoreParam, (CipherParam)cipherParam);
    }

    private LicenseContent initLicenseContent(LicenseCreatorParam param) {
        LicenseContent licenseContent = new LicenseContent();
        licenseContent.setHolder(DEFAULT_HOLDER_ISSUER);
        licenseContent.setIssuer(DEFAULT_HOLDER_ISSUER);
        licenseContent.setSubject(param.getSubject());
        licenseContent.setIssued(param.getIssuedTime());
        licenseContent.setNotBefore(param.getIssuedTime());
        licenseContent.setNotAfter(param.getExpiryTime());
        licenseContent.setConsumerType(param.getConsumerType());
        licenseContent.setConsumerAmount(param.getConsumerAmount().intValue());
        licenseContent.setInfo(param.getDescription());
        if (param.getLicenseExtraModel() != null) {
            licenseContent.setExtra((Object)param.getLicenseExtraModel());
        }
        return licenseContent;
    }

    @Generated
    private LicenseCreateService() {
    }

    static {
        DEFAULT_HOLDER_ISSUER = new X500Principal("CN=localhost, OU=localhost, O=localhost, L=SH, ST=SH, C=CN");
    }
}

