/*
 * Decompiled with CFR 0.152.
 */
package com.cssw.bootx.log.aspect;

import com.cssw.bootx.log.handler.LogHandler;
import com.cssw.bootx.log.model.AccessLogContext;
import com.cssw.bootx.log.model.LogProperties;
import java.time.Instant;
import lombok.Generated;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
public class AccessLogAspect {
    private final LogProperties logProperties;
    private final LogHandler logHandler;

    @Pointcut(value="@annotation(org.springframework.web.bind.annotation.RequestMapping)")
    public void pointcut() {
    }

    @Pointcut(value="@annotation(org.springframework.web.bind.annotation.GetMapping)")
    public void pointcutGet() {
    }

    @Pointcut(value="@annotation(org.springframework.web.bind.annotation.PostMapping)")
    public void pointcutPost() {
    }

    @Pointcut(value="@annotation(org.springframework.web.bind.annotation.PutMapping)")
    public void pointcutPut() {
    }

    @Pointcut(value="@annotation(org.springframework.web.bind.annotation.DeleteMapping)")
    public void pointcutDelete() {
    }

    @Pointcut(value="@annotation(org.springframework.web.bind.annotation.PatchMapping)")
    public void pointcutPatch() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="pointcut() || pointcutGet() || pointcutPost() || pointcutPut() || pointcutDelete() || pointcutPatch()")
    public Object around(ProceedingJoinPoint joinPoint) throws Throwable {
        Instant startTime = Instant.now();
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (attributes == null) {
            return joinPoint.proceed();
        }
        try {
            this.logHandler.accessLogStart(AccessLogContext.builder().startTime(startTime).properties(this.logProperties).build());
            Object object = joinPoint.proceed();
            return object;
        }
        finally {
            Instant endTime = Instant.now();
            this.logHandler.accessLogFinish(AccessLogContext.builder().endTime(endTime).build());
        }
    }

    @Generated
    public AccessLogAspect(LogProperties logProperties, LogHandler logHandler) {
        this.logProperties = logProperties;
        this.logHandler = logHandler;
    }
}

