/*
 * Decompiled with CFR 0.152.
 */
package com.cssw.bootx.log.interceptor;

import com.alibaba.ttl.TransmittableThreadLocal;
import com.cssw.bootx.log.dao.LogDao;
import com.cssw.bootx.log.handler.LogHandler;
import com.cssw.bootx.log.model.AccessLogContext;
import com.cssw.bootx.log.model.LogProperties;
import com.cssw.bootx.log.model.LogRecord;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.lang.reflect.Method;
import java.time.Instant;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;

public class LogInterceptor
implements HandlerInterceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LogInterceptor.class);
    private final LogProperties logProperties;
    private final LogHandler logHandler;
    private final LogDao logDao;
    private final TransmittableThreadLocal<LogRecord.Started> logTtl = new TransmittableThreadLocal();

    public boolean preHandle(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull Object handler) {
        Instant startTime = Instant.now();
        this.logHandler.accessLogStart(AccessLogContext.builder().startTime(startTime).properties(this.logProperties).build());
        if (this.isRecord(handler)) {
            LogRecord.Started startedLogRecord = this.logHandler.start(startTime);
            this.logTtl.set((Object)startedLogRecord);
        }
        return true;
    }

    public void afterCompletion(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull Object handler, Exception e) {
        try {
            Instant endTime = Instant.now();
            this.logHandler.accessLogFinish(AccessLogContext.builder().endTime(endTime).build());
            LogRecord.Started startedLogRecord = (LogRecord.Started)this.logTtl.get();
            if (startedLogRecord == null) {
                return;
            }
            HandlerMethod handlerMethod = (HandlerMethod)handler;
            Method targetMethod = handlerMethod.getMethod();
            Class targetClass = handlerMethod.getBeanType();
            LogRecord logRecord = this.logHandler.finish(startedLogRecord, endTime, this.logProperties.getIncludes(), targetMethod, targetClass);
            this.logDao.add(logRecord);
        }
        catch (Exception ex) {
            log.error("Logging http log occurred an error: {}.", (Object)ex.getMessage(), (Object)ex);
            throw ex;
        }
        finally {
            this.logTtl.remove();
        }
    }

    private boolean isRecord(Object handler) {
        if (!(handler instanceof HandlerMethod)) {
            return false;
        }
        HandlerMethod handlerMethod = (HandlerMethod)handler;
        return this.logHandler.isRecord(handlerMethod.getMethod(), handlerMethod.getBeanType());
    }

    @Generated
    public LogInterceptor(LogProperties logProperties, LogHandler logHandler, LogDao logDao) {
        this.logProperties = logProperties;
        this.logHandler = logHandler;
        this.logDao = logDao;
    }
}

