/*
 * Decompiled with CFR 0.152.
 */
package com.cssw.bootx.security.mask.enums;

import cn.hutool.core.text.CharSequenceUtil;
import com.cssw.bootx.security.mask.strategy.IMaskStrategy;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum MaskType implements IMaskStrategy
{
    CUSTOM{

        @Override
        public String mask(String str, char character, int left, int right) {
            return CharSequenceUtil.replaceByCodePoint((CharSequence)str, (int)left, (int)(str.length() - right), (char)character);
        }
    }
    ,
    MOBILE_PHONE{

        @Override
        public String mask(String str, char character, int left, int right) {
            return CharSequenceUtil.replaceByCodePoint((CharSequence)str, (int)3, (int)(str.length() - 4), (char)character);
        }
    }
    ,
    FIXED_PHONE{

        @Override
        public String mask(String str, char character, int left, int right) {
            return CharSequenceUtil.replaceByCodePoint((CharSequence)str, (int)4, (int)(str.length() - 2), (char)character);
        }
    }
    ,
    EMAIL{

        @Override
        public String mask(String str, char character, int left, int right) {
            int index = str.indexOf("@");
            if (index <= 1) {
                return str;
            }
            return CharSequenceUtil.replaceByCodePoint((CharSequence)str, (int)1, (int)index, (char)character);
        }
    }
    ,
    ID_CARD{

        @Override
        public String mask(String str, char character, int left, int right) {
            return CharSequenceUtil.replaceByCodePoint((CharSequence)str, (int)1, (int)(str.length() - 2), (char)character);
        }
    }
    ,
    BANK_CARD{

        @Override
        public String mask(String str, char character, int left, int right) {
            String cleanStr = CharSequenceUtil.cleanBlank((CharSequence)str);
            if (cleanStr.length() < 9) {
                return cleanStr;
            }
            int length = cleanStr.length();
            int endLength = length % 4 == 0 ? 4 : length % 4;
            int midLength = length - 4 - endLength;
            StringBuilder buffer = new StringBuilder();
            buffer.append(cleanStr, 0, 4);
            for (int i = 0; i < midLength; ++i) {
                if (i % 4 == 0) {
                    buffer.append(" ");
                }
                buffer.append(character);
            }
            buffer.append(" ").append(cleanStr, length - endLength, length);
            return buffer.toString();
        }
    }
    ,
    CAR_LICENSE{

        @Override
        public String mask(String str, char character, int left, int right) {
            int length = str.length();
            if (length == 7) {
                return CharSequenceUtil.replaceByCodePoint((CharSequence)str, (int)3, (int)6, (char)character);
            }
            if (length == 8) {
                return CharSequenceUtil.replaceByCodePoint((CharSequence)str, (int)3, (int)7, (char)character);
            }
            return str;
        }
    }
    ,
    CHINESE_NAME{

        @Override
        public String mask(String str, char character, int left, int right) {
            return CharSequenceUtil.replaceByCodePoint((CharSequence)str, (int)1, (int)str.length(), (char)character);
        }
    }
    ,
    PASSWORD{

        @Override
        public String mask(String str, char character, int left, int right) {
            return CharSequenceUtil.repeat((char)character, (int)str.length());
        }
    }
    ,
    ADDRESS{

        @Override
        public String mask(String str, char character, int left, int right) {
            int length = str.length();
            return CharSequenceUtil.replaceByCodePoint((CharSequence)str, (int)(length - 8), (int)length, (char)character);
        }
    }
    ,
    IPV4{

        @Override
        public String mask(String str, char character, int left, int right) {
            return CharSequenceUtil.subBefore((CharSequence)str, (CharSequence)".", (boolean)false) + String.format(".%s.%s.%s", Character.valueOf(character), Character.valueOf(character), Character.valueOf(character));
        }
    }
    ,
    IPV6{

        @Override
        public String mask(String str, char character, int left, int right) {
            return CharSequenceUtil.subBefore((CharSequence)str, (CharSequence)":", (boolean)false) + String.format(":%s:%s:%s:%s:%s:%s:%s", Character.valueOf(character), Character.valueOf(character), Character.valueOf(character), Character.valueOf(character), Character.valueOf(character), Character.valueOf(character), Character.valueOf(character));
        }
    };

}

