/*
 * Decompiled with CFR 0.152.
 */
package com.cssw.bootx.security.xss.autoconfigure;

import com.cssw.bootx.security.xss.autoconfigure.XssProperties;
import com.cssw.bootx.security.xss.filter.XssFilter;
import jakarta.annotation.PostConstruct;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@ConditionalOnWebApplication
@EnableConfigurationProperties(value={XssProperties.class})
@ConditionalOnProperty(prefix="bootx-starter.security.xss", name={"enabled"}, havingValue="true")
public class XssAutoConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(XssAutoConfiguration.class);

    @Bean
    public FilterRegistrationBean<XssFilter> xssFilter(XssProperties xssProperties) {
        FilterRegistrationBean registrationBean = new FilterRegistrationBean();
        registrationBean.setFilter((Filter)new XssFilter(xssProperties));
        registrationBean.setOrder(-2147483448);
        registrationBean.addUrlPatterns(new String[]{"/*"});
        registrationBean.setDispatcherTypes(DispatcherType.REQUEST, new DispatcherType[0]);
        return registrationBean;
    }

    @PostConstruct
    public void postConstruct() {
        log.debug("[Bootx Starter] - Auto Configuration 'Security-XSS' completed initialization.");
    }
}

