/*
 * Decompiled with CFR 0.152.
 */
package com.cssw.bootx.security.xss.filter;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.EscapeUtil;
import cn.hutool.core.util.ReUtil;
import cn.hutool.http.HtmlUtil;
import cn.hutool.http.Method;
import com.cssw.bootx.security.xss.autoconfigure.XssProperties;
import com.cssw.bootx.security.xss.enums.XssMode;
import jakarta.servlet.ReadListener;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.List;

public class XssServletRequestWrapper
extends HttpServletRequestWrapper {
    private final XssProperties xssProperties;
    private String body = "";

    public XssServletRequestWrapper(HttpServletRequest request, XssProperties xssProperties) throws IOException {
        super(request);
        this.xssProperties = xssProperties;
        if (CharSequenceUtil.equalsAnyIgnoreCase((CharSequence)request.getMethod().toUpperCase(), (CharSequence[])new CharSequence[]{Method.POST.name(), Method.PATCH.name(), Method.PUT.name()})) {
            this.body = IoUtil.getReader((Reader)request.getReader()).readLine();
            if (CharSequenceUtil.isBlank((CharSequence)this.body)) {
                return;
            }
            this.body = this.handleTag(this.body);
        }
    }

    public BufferedReader getReader() {
        return IoUtil.toBuffered((Reader)new StringReader(this.body));
    }

    public ServletInputStream getInputStream() {
        return XssServletRequestWrapper.getServletInputStream(this.body);
    }

    public String getQueryString() {
        return this.handleTag(super.getQueryString());
    }

    public String getParameter(String name) {
        return this.handleTag(super.getParameter(name));
    }

    public String[] getParameterValues(String name) {
        Object[] values = super.getParameterValues(name);
        if (ArrayUtil.isEmpty((Object[])values)) {
            return values;
        }
        int length = values.length;
        String[] resultValues = new String[length];
        for (int i = 0; i < length; ++i) {
            resultValues[i] = this.handleTag((String)values[i]);
        }
        return resultValues;
    }

    private String handleTag(String content) {
        if (CharSequenceUtil.isBlank((CharSequence)content)) {
            return content;
        }
        XssMode mode = this.xssProperties.getMode();
        if (XssMode.ESCAPE.equals((Object)mode)) {
            List reStr = ReUtil.findAllGroup0((String)"(<[^<]*?>)|(<[\\s]*?/[^<]*?>)|(<[^<]*?/[\\s]*?>)", (CharSequence)content);
            if (CollUtil.isEmpty((Collection)reStr)) {
                return content;
            }
            for (String s : reStr) {
                content = content.replace(s, EscapeUtil.escapeHtml4((CharSequence)s).replace("\\", ""));
            }
            return content;
        }
        return HtmlUtil.cleanHtmlTag((String)content);
    }

    static ServletInputStream getServletInputStream(String body) {
        final ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(body.getBytes());
        return new ServletInputStream(){

            public int read() {
                return byteArrayInputStream.read();
            }

            public boolean isFinished() {
                return byteArrayInputStream.available() == 0;
            }

            public boolean isReady() {
                return false;
            }

            public void setReadListener(ReadListener readListener) {
            }
        };
    }
}

