/*
 * Decompiled with CFR 0.152.
 */
package com.cssw.bootx.storage.autoconfigure;

import com.cssw.bootx.storage.annotation.PlatformProcessor;
import com.cssw.bootx.storage.autoconfigure.LocalStorageAutoConfiguration;
import com.cssw.bootx.storage.autoconfigure.OssStorageAutoConfiguration;
import com.cssw.bootx.storage.autoconfigure.properties.StorageProperties;
import com.cssw.bootx.storage.core.FileStorageService;
import com.cssw.bootx.storage.engine.StorageDecoratorManager;
import com.cssw.bootx.storage.engine.StorageStrategyRegistrar;
import com.cssw.bootx.storage.engine.StorageStrategyRouter;
import com.cssw.bootx.storage.processor.preprocess.FileNameGenerator;
import com.cssw.bootx.storage.processor.preprocess.FilePathGenerator;
import com.cssw.bootx.storage.processor.preprocess.FileValidator;
import com.cssw.bootx.storage.processor.preprocess.ThumbnailProcessor;
import com.cssw.bootx.storage.processor.preprocess.impl.DefaultFileNameGenerator;
import com.cssw.bootx.storage.processor.preprocess.impl.DefaultFilePathGenerator;
import com.cssw.bootx.storage.processor.preprocess.impl.DefaultThumbnailProcessor;
import com.cssw.bootx.storage.processor.preprocess.impl.FileSizeValidator;
import com.cssw.bootx.storage.processor.preprocess.impl.FileTypeValidator;
import com.cssw.bootx.storage.processor.registry.ProcessorRegistry;
import com.cssw.bootx.storage.service.FileProcessor;
import com.cssw.bootx.storage.service.FileRecorder;
import com.cssw.bootx.storage.service.impl.DefaultFileRecorder;
import jakarta.annotation.PostConstruct;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.web.servlet.MultipartProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;

@AutoConfiguration
@EnableConfigurationProperties(value={StorageProperties.class})
@Import(value={ProcessorRegistry.class})
public class StorageAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(StorageAutoConfiguration.class);
    private final StorageProperties properties;
    private final ApplicationContext applicationContext;

    public StorageAutoConfiguration(StorageProperties properties, ApplicationContext applicationContext) {
        this.properties = properties;
        this.applicationContext = applicationContext;
    }

    @Bean
    public StorageStrategyRouter strategyRouter(List<StorageStrategyRegistrar> registrars) {
        return new StorageStrategyRouter(registrars, this.properties, this.storageDecoratorManager());
    }

    @Bean
    public StorageDecoratorManager storageDecoratorManager() {
        return new StorageDecoratorManager(this.applicationContext);
    }

    @Bean
    public OssStorageAutoConfiguration ossStorageAutoConfiguration() {
        return new OssStorageAutoConfiguration(this.properties);
    }

    @Bean
    public LocalStorageAutoConfiguration localStorageAutoConfiguration() {
        return new LocalStorageAutoConfiguration(this.properties);
    }

    @Bean
    public FileStorageService fileStorageService(StorageStrategyRouter router, StorageProperties storageProperties, ProcessorRegistry processorRegistry, FileRecorder fileRecorder) {
        return new FileStorageService(router, storageProperties, processorRegistry, fileRecorder);
    }

    @Bean
    @ConditionalOnMissingBean
    public FileRecorder fileRecorder() {
        return new DefaultFileRecorder();
    }

    @Bean
    public ProcessorRegistry processorRegistry() {
        ProcessorRegistry registry = new ProcessorRegistry();
        Map processors = this.applicationContext.getBeansOfType(FileProcessor.class);
        processors.values().forEach(processor -> {
            PlatformProcessor annotation = processor.getClass().getAnnotation(PlatformProcessor.class);
            if (annotation != null) {
                for (String platform : annotation.platforms()) {
                    registry.register((FileProcessor)processor, platform);
                }
            } else {
                registry.register((FileProcessor)processor);
            }
        });
        return registry;
    }

    @Bean
    @ConditionalOnMissingBean(value={FileNameGenerator.class})
    public FileNameGenerator defaultFileNameGenerator() {
        return new DefaultFileNameGenerator();
    }

    @Bean
    @ConditionalOnMissingBean(value={FilePathGenerator.class})
    public FilePathGenerator defaultFilePathGenerator() {
        return new DefaultFilePathGenerator();
    }

    @Bean
    @ConditionalOnMissingBean(value={ThumbnailProcessor.class})
    @ConditionalOnClass(name={"net.coobird.thumbnailator.Thumbnails"})
    public ThumbnailProcessor defaultThumbnailProcessor() {
        return new DefaultThumbnailProcessor();
    }

    @Bean
    @ConditionalOnMissingBean(name={"fileSizeValidator"})
    public FileValidator fileSizeValidator(MultipartProperties multipartProperties) {
        return new FileSizeValidator(multipartProperties);
    }

    @Bean
    @ConditionalOnMissingBean(name={"fileTypeValidator"})
    public FileValidator fileTypeValidator() {
        return new FileTypeValidator();
    }

    @PostConstruct
    public void postConstruct() {
        log.debug("[Bootx Starter] - Auto Configuration 'Storage' completed initialization.");
    }
}

