/*
 * Decompiled with CFR 0.152.
 */
package com.cssw.bootx.storage.common.util;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import java.time.LocalDate;
import java.util.Date;
import software.amazon.awssdk.regions.Region;

public class StorageUtils {
    public static Region getRegion(String region) {
        return StrUtil.isEmpty((CharSequence)region) ? Region.US_EAST_1 : Region.of((String)region);
    }

    public static String generatePath() {
        LocalDate date = LocalDate.now();
        return String.format("%d/%d/%d/", date.getYear(), date.getMonthValue(), date.getDayOfMonth());
    }

    public static String generateFileName(String originalFilename) {
        return StorageUtils.generateFileName(originalFilename, null, false);
    }

    public static String generateFileName(String originalFilename, String prefix) {
        return StorageUtils.generateFileName(originalFilename, prefix, false);
    }

    public static String generateFileName(String originalFilename, String prefix, boolean useMillis) {
        String extension = FileUtil.getSuffix((String)originalFilename);
        String timestamp = useMillis ? String.valueOf(System.currentTimeMillis()) : DateUtil.format((Date)DateUtil.date(), (String)"yyyyMMddHHmmssSSS");
        String fileName = StrUtil.isNotBlank((CharSequence)prefix) ? prefix + "_" + timestamp : timestamp;
        return fileName + (String)(StrUtil.isNotBlank((CharSequence)extension) ? "." + extension : "");
    }
}

