/*
 * Decompiled with CFR 0.152.
 */
package com.cssw.bootx.storage.core;

import cn.hutool.core.util.StrUtil;
import com.cssw.bootx.storage.core.FileStorageService;
import com.cssw.bootx.storage.domain.model.context.UploadContext;
import com.cssw.bootx.storage.domain.model.req.ThumbnailSize;
import com.cssw.bootx.storage.domain.model.resp.FileInfo;
import com.cssw.bootx.storage.processor.progress.UploadProgressListener;
import com.cssw.bootx.storage.service.FileProcessor;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.springframework.web.multipart.MultipartFile;

public class UploadPretreatment {
    private final FileStorageService storageService;
    private final UploadContext context;
    private UploadProgressListener progressListener;
    private final List<FileProcessor> processors = new ArrayList<FileProcessor>();

    public UploadPretreatment(FileStorageService storageService, MultipartFile file) {
        this.storageService = storageService;
        this.context = new UploadContext();
        this.context.setFile(file);
    }

    public UploadPretreatment platform(String platform) {
        this.context.setPlatform(platform);
        return this;
    }

    public UploadPretreatment bucket(String bucket) {
        this.context.setBucket(bucket);
        return this;
    }

    public UploadPretreatment path(String path) {
        this.context.setPath(path);
        return this;
    }

    public UploadPretreatment fileName(String fileName) {
        this.context.setFormatFileName(fileName);
        return this;
    }

    public UploadPretreatment metadata(String key, String value) {
        this.context.getMetadata().put(key, value);
        return this;
    }

    public UploadPretreatment processor(FileProcessor processor) {
        this.processors.add(processor);
        return this;
    }

    public UploadPretreatment thumbnail(int width, int height) {
        this.context.setGenerateThumbnail(true);
        this.context.setThumbnailSize(new ThumbnailSize(width, height));
        return this;
    }

    public UploadPretreatment onProgress(UploadProgressListener listener) {
        this.progressListener = listener;
        return this;
    }

    public UploadPretreatment onProgress(Consumer<Integer> progressConsumer) {
        this.progressListener = (bytesRead, totalBytes, percentage) -> progressConsumer.accept(percentage);
        return this;
    }

    public FileInfo upload() {
        for (FileProcessor processor : this.processors) {
            this.storageService.addProcessor(processor);
        }
        if (this.progressListener != null) {
            this.storageService.onProgress(this.progressListener);
        }
        if (StrUtil.isBlank((CharSequence)this.context.getPlatform())) {
            this.context.setPlatform(this.storageService.getDefaultPlatform());
        }
        return this.storageService.upload(this.context);
    }
}

