/*
 * Decompiled with CFR 0.152.
 */
package com.cssw.bootx.storage.domain.file;

import com.cssw.bootx.storage.domain.file.EnhancedMultipartFile;
import com.cssw.bootx.storage.processor.progress.ProgressInputStream;
import com.cssw.bootx.storage.processor.progress.ProgressTracker;
import com.cssw.bootx.storage.processor.progress.UploadProgressListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.springframework.web.multipart.MultipartFile;

public class ProgressAwareMultipartFile
extends EnhancedMultipartFile {
    private final UploadProgressListener progressListener;
    private volatile ProgressTracker progressTracker;
    private volatile boolean progressEnabled = false;
    private final Object progressLock = new Object();
    private volatile ReadPhase currentPhase = ReadPhase.VALIDATION;

    public ProgressAwareMultipartFile(MultipartFile originalFile, boolean enableCache, UploadProgressListener progressListener) {
        super(originalFile, enableCache);
        this.progressListener = progressListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReadPhase(ReadPhase phase) {
        Object object = this.progressLock;
        synchronized (object) {
            this.currentPhase = phase;
            boolean bl = this.progressEnabled = phase == ReadPhase.UPLOAD;
            if (phase == ReadPhase.UPLOAD && this.progressListener != null) {
                this.progressTracker = new ProgressTracker(this.getSize(), this.progressListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getInputStream() throws IOException {
        InputStream originalStream = super.getInputStream();
        Object object = this.progressLock;
        synchronized (object) {
            if (this.progressEnabled && this.progressTracker != null) {
                return new ProgressInputStream(originalStream, this.progressTracker);
            }
        }
        return originalStream;
    }

    @Override
    public void transferTo(File dest) throws IOException, IllegalStateException {
        block13: {
            if (this.progressEnabled && this.progressTracker != null) {
                try (InputStream in = this.getInputStream();
                     FileOutputStream out = new FileOutputStream(dest);){
                    int bytesRead;
                    byte[] buffer = new byte[8192];
                    while ((bytesRead = in.read(buffer)) != -1) {
                        ((OutputStream)out).write(buffer, 0, bytesRead);
                    }
                    break block13;
                }
            }
            super.transferTo(dest);
        }
    }

    public InputStream getInputStreamWithoutProgress() throws IOException {
        return super.getInputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCache() {
        super.clearCache();
        Object object = this.progressLock;
        synchronized (object) {
            this.progressTracker = null;
        }
    }

    public static enum ReadPhase {
        VALIDATION,
        THUMBNAIL,
        UPLOAD;

    }
}

