/*
 * Decompiled with CFR 0.152.
 */
package com.cssw.bootx.storage.engine;

import com.cssw.bootx.storage.strategy.StorageStrategy;
import com.cssw.bootx.storage.strategy.impl.StorageStrategyDecorator;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;

public class StorageDecoratorManager {
    private final ApplicationContext applicationContext;
    private final Map<Class<? extends StorageStrategy>, List<StorageStrategyDecorator<?>>> decoratorMap = new ConcurrentHashMap();
    private volatile boolean initialized = false;

    public StorageDecoratorManager(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @PostConstruct
    public void init() {
        if (this.initialized) {
            return;
        }
        Map decorators = this.applicationContext.getBeansOfType(StorageStrategyDecorator.class);
        for (Map.Entry entry : decorators.entrySet()) {
            StorageStrategyDecorator decorator = (StorageStrategyDecorator)entry.getValue();
            Class targetClass = decorator.getTargetStrategyClass();
            if (targetClass == null) continue;
            this.decoratorMap.computeIfAbsent(targetClass, k -> new ArrayList()).add(decorator);
        }
        this.decoratorMap.values().forEach(list -> list.sort(Comparator.comparingInt(StorageStrategyDecorator::getOrder)));
        this.initialized = true;
    }

    public StorageStrategy applyDecorators(StorageStrategy strategy) {
        if (!this.initialized) {
            this.init();
        }
        if (strategy == null) {
            return null;
        }
        Class<?> strategyClass = strategy.getClass();
        List<StorageStrategyDecorator<?>> decorators = this.findApplicableDecorators(strategyClass);
        if (decorators.isEmpty()) {
            return strategy;
        }
        StorageStrategyDecorator<?> decorated = strategy;
        for (StorageStrategyDecorator<?> decorator : decorators) {
            decorator.setDelegate(decorated);
            decorated = decorator;
        }
        return decorated;
    }

    private List<StorageStrategyDecorator<?>> findApplicableDecorators(Class<? extends StorageStrategy> strategyClass) {
        ArrayList result = new ArrayList();
        List<StorageStrategyDecorator<?>> exactMatch = this.decoratorMap.get(strategyClass);
        if (exactMatch != null) {
            result.addAll(exactMatch);
        }
        for (Map.Entry<Class<StorageStrategy>, List<StorageStrategyDecorator<?>>> entry : this.decoratorMap.entrySet()) {
            if (entry.getKey() == strategyClass || !entry.getKey().isAssignableFrom(strategyClass)) continue;
            result.addAll((Collection)entry.getValue());
        }
        return result.stream().distinct().sorted(Comparator.comparingInt(StorageStrategyDecorator::getOrder)).collect(Collectors.toList());
    }

    public void registerDecorator(StorageStrategyDecorator<?> decorator) {
        Class<?> targetClass = decorator.getTargetStrategyClass();
        if (targetClass != null) {
            this.decoratorMap.computeIfAbsent(targetClass, k -> new ArrayList()).add(decorator);
            this.decoratorMap.get(targetClass).sort(Comparator.comparingInt(StorageStrategyDecorator::getOrder));
        }
    }

    public void unregisterDecorator(StorageStrategyDecorator<?> decorator) {
        List<StorageStrategyDecorator<?>> decorators;
        Class<?> targetClass = decorator.getTargetStrategyClass();
        if (targetClass != null && (decorators = this.decoratorMap.get(targetClass)) != null) {
            decorators.remove(decorator);
        }
    }

    public static class DecoratorUnregisteredEvent
    extends ApplicationEvent {
        private final Class<?> targetClass;

        public DecoratorUnregisteredEvent(Object source, Class<?> targetClass) {
            super(source);
            this.targetClass = targetClass;
        }

        public Class<?> getTargetClass() {
            return this.targetClass;
        }
    }

    public static class DecoratorRegisteredEvent
    extends ApplicationEvent {
        private final Class<?> targetClass;

        public DecoratorRegisteredEvent(Object source, Class<?> targetClass) {
            super(source);
            this.targetClass = targetClass;
        }

        public Class<?> getTargetClass() {
            return this.targetClass;
        }
    }
}

