/*
 * Decompiled with CFR 0.152.
 */
package com.cssw.bootx.storage.engine;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.cssw.bootx.storage.autoconfigure.properties.StorageProperties;
import com.cssw.bootx.storage.common.enums.DefaultStorageSource;
import com.cssw.bootx.storage.common.exception.StorageException;
import com.cssw.bootx.storage.domain.model.resp.StrategyStatusResp;
import com.cssw.bootx.storage.engine.StorageDecoratorManager;
import com.cssw.bootx.storage.engine.StorageStrategyRegistrar;
import com.cssw.bootx.storage.strategy.StorageStrategy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;

public class StorageStrategyRouter
implements ApplicationListener<ApplicationEvent> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StorageStrategyRouter.class);
    private final Map<String, StorageStrategy> configStrategies = new ConcurrentHashMap<String, StorageStrategy>();
    private final Map<String, StorageStrategy> dynamicStrategies = new ConcurrentHashMap<String, StorageStrategy>();
    private final Map<String, StorageStrategy> decoratedStrategies = new ConcurrentHashMap<String, StorageStrategy>();
    private final StorageProperties storageProperties;
    private final String configDefaultPlatform;
    private volatile String dynamicDefaultPlatform;
    private final StorageDecoratorManager decoratorManager;

    public StorageStrategyRouter(List<StorageStrategyRegistrar> registrars, StorageProperties storageProperties, StorageDecoratorManager decoratorManager) {
        this.decoratorManager = decoratorManager;
        this.storageProperties = storageProperties;
        ArrayList<StorageStrategy> strategies = new ArrayList<StorageStrategy>();
        for (StorageStrategyRegistrar registrar : registrars) {
            registrar.register(strategies);
        }
        for (StorageStrategy strategy : strategies) {
            this.configStrategies.put(strategy.getPlatform(), strategy);
        }
        this.configDefaultPlatform = storageProperties.getDefaultPlatform();
    }

    public StorageStrategy route(String platform) {
        StorageStrategy decorated = this.decoratedStrategies.get(platform);
        if (decorated != null) {
            return decorated;
        }
        StorageStrategy strategy = this.getOriginalStrategy(platform);
        StorageStrategy decoratedStrategy = this.applyDecoratorsIfAvailable(strategy);
        this.decoratedStrategies.put(platform, decoratedStrategy);
        return decoratedStrategy;
    }

    private StorageStrategy getOriginalStrategy(String platform) {
        return Optional.ofNullable(this.dynamicStrategies.get(platform)).or(() -> Optional.ofNullable(this.configStrategies.get(platform))).orElseThrow(() -> new StorageException(String.format("\u4e0d\u652f\u6301\u7684\u5b58\u50a8\u5e73\u53f0: %s", platform)));
    }

    private StorageStrategy applyDecoratorsIfAvailable(StorageStrategy strategy) {
        return ObjectUtil.isNotEmpty((Object)this.decoratorManager) ? this.decoratorManager.applyDecorators(strategy) : strategy;
    }

    public void registerDynamic(StorageStrategy strategy) {
        String platform = strategy.getPlatform();
        if (this.dynamicStrategies.containsKey(platform)) {
            throw new StorageException("\u52a8\u6001\u7b56\u7565 platform \u5df2\u5b58\u5728: " + platform);
        }
        this.dynamicStrategies.put(platform, strategy);
        this.decoratedStrategies.remove(platform);
    }

    public boolean unloadDynamic(String platform) {
        StorageStrategy strategy = this.dynamicStrategies.remove(platform);
        if (strategy == null) {
            return false;
        }
        this.decoratedStrategies.remove(platform);
        try {
            strategy.cleanup();
        }
        catch (Exception e) {
            log.error("\u6e05\u7406\u5b58\u50a8\u7b56\u7565\u5931\u8d25: platform={}", (Object)platform, (Object)e);
        }
        return true;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof StorageDecoratorManager.DecoratorRegisteredEvent || event instanceof StorageDecoratorManager.DecoratorUnregisteredEvent) {
            this.decoratedStrategies.clear();
        }
    }

    public void registerDynamicDefaultStorage(String platform) {
        this.dynamicDefaultPlatform = platform;
    }

    public String getDefaultStorage() {
        DefaultStorageSource defaultStorageSource = this.storageProperties.getDefaultStorageSource();
        return switch (defaultStorageSource) {
            default -> throw new IncompatibleClassChangeError();
            case DefaultStorageSource.DYNAMIC -> {
                if (StrUtil.isBlank((CharSequence)this.dynamicDefaultPlatform)) {
                    throw new StorageException("\u52a8\u6001\u9ed8\u8ba4\u5b58\u50a8\u5e73\u53f0\u914d\u7f6e\u4e3a\u7a7a");
                }
                yield this.dynamicDefaultPlatform;
            }
            case DefaultStorageSource.CONFIG -> {
                if (StrUtil.isBlank((CharSequence)this.configDefaultPlatform)) {
                    throw new StorageException("\u914d\u7f6e\u9ed8\u8ba4\u5b58\u50a8\u5e73\u53f0\u914d\u7f6e\u4e3a\u7a7a");
                }
                yield this.configDefaultPlatform;
            }
        };
    }

    public Set<String> getAllPlatform() {
        HashSet<String> allPlatform = new HashSet<String>(this.configStrategies.keySet());
        allPlatform.addAll(this.dynamicStrategies.keySet());
        return allPlatform;
    }

    public boolean isDynamic(String platform) {
        return this.dynamicStrategies.containsKey(platform);
    }

    public boolean isFromConfig(String platform) {
        return this.configStrategies.containsKey(platform);
    }

    public Map<String, String> getActiveStrategyInfo() {
        HashMap<String, String> info = new HashMap<String, String>();
        this.configStrategies.keySet().forEach(platform -> info.put((String)platform, "CONFIG"));
        this.dynamicStrategies.keySet().forEach(platform -> info.put((String)platform, "DYNAMIC"));
        return info;
    }

    public Map<String, StrategyStatusResp> getFullStrategyStatus() {
        HashMap<String, StrategyStatusResp> status = new HashMap<String, StrategyStatusResp>();
        HashSet<String> appPlatform = new HashSet<String>();
        appPlatform.addAll(this.configStrategies.keySet());
        appPlatform.addAll(this.dynamicStrategies.keySet());
        for (String platform : appPlatform) {
            Object statusDesc;
            boolean hasConfig = this.configStrategies.containsKey(platform);
            boolean hasDynamic = this.dynamicStrategies.containsKey(platform);
            boolean hasDecorated = this.decoratedStrategies.containsKey(platform);
            String activeType = hasDynamic ? "DYNAMIC" : "CONFIG";
            Object object = statusDesc = hasDynamic && hasConfig ? "\u914d\u7f6e\u7b56\u7565\u88ab\u8986\u76d6" : "\u6b63\u5e38";
            if (hasDecorated) {
                statusDesc = (String)statusDesc + " (\u5df2\u88c5\u9970)";
            }
            StrategyStatusResp strategyStatusResp = new StrategyStatusResp(platform, hasConfig, hasDynamic, activeType, (String)statusDesc);
            status.put(platform, strategyStatusResp);
        }
        return status;
    }
}

