/*
 * Decompiled with CFR 0.152.
 */
package com.cssw.bootx.storage.processor.preprocess.impl;

import cn.hutool.core.io.FileUtil;
import com.cssw.bootx.storage.common.constant.StorageConstant;
import com.cssw.bootx.storage.common.exception.StorageException;
import com.cssw.bootx.storage.domain.model.context.UploadContext;
import com.cssw.bootx.storage.processor.preprocess.FileValidator;
import org.springframework.boot.autoconfigure.web.servlet.MultipartProperties;

public class FileSizeValidator
implements FileValidator {
    private final long maxSize;

    public FileSizeValidator(MultipartProperties multipartProperties) {
        this.maxSize = multipartProperties.getMaxFileSize().toBytes();
    }

    public FileSizeValidator() {
        this(StorageConstant.DEFAULT_FILE_SIZE);
    }

    public FileSizeValidator(long maxSize) {
        this.maxSize = maxSize;
    }

    @Override
    public String getName() {
        return FileSizeValidator.class.getSimpleName();
    }

    @Override
    public boolean support(UploadContext context) {
        return true;
    }

    @Override
    public void validate(UploadContext context) throws StorageException {
        long fileSize = context.getFile().getSize();
        if (fileSize > this.maxSize) {
            throw new StorageException(String.format("\u6587\u4ef6\u5927\u5c0f\u8d85\u8fc7\u9650\u5236: %s (\u5f53\u524d: %s)", FileUtil.readableFileSize((long)this.maxSize), FileUtil.readableFileSize((long)fileSize)));
        }
    }

    public FileSizeValidator create() {
        return new FileSizeValidator(this.maxSize);
    }

    public static FileSizeValidator maxSize(long bytes) {
        return new FileSizeValidator(bytes);
    }

    public static FileSizeValidator maxKB(long kb) {
        return new FileSizeValidator(kb * 1024L);
    }

    public static FileSizeValidator maxMB(long mb) {
        return new FileSizeValidator(mb * 1024L * 1024L);
    }

    public static FileSizeValidator maxGB(long gb) {
        return new FileSizeValidator(gb * 1024L * 1024L * 1024L);
    }
}

