/*
 * Decompiled with CFR 0.152.
 */
package com.cssw.kylin.http;

import com.cssw.kylin.http.AsyncCallback;
import com.cssw.kylin.http.HttpResponse;
import com.cssw.kylin.http.ResponseSpec;
import java.io.IOException;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Request;

public class AsyncCall {
    private static final Consumer<ResponseSpec> DEFAULT_CONSUMER = r -> {};
    private static final BiConsumer<Request, IOException> DEFAULT_FAIL_CONSUMER = (r, e) -> {};
    private final Call call;
    private Consumer<ResponseSpec> successConsumer;
    private Consumer<ResponseSpec> responseConsumer;
    private BiConsumer<Request, IOException> failedBiConsumer;

    AsyncCall(Call call) {
        this.call = call;
        this.successConsumer = DEFAULT_CONSUMER;
        this.responseConsumer = DEFAULT_CONSUMER;
        this.failedBiConsumer = DEFAULT_FAIL_CONSUMER;
    }

    public void onSuccessful(Consumer<ResponseSpec> consumer) {
        this.successConsumer = consumer;
        this.execute();
    }

    public void onResponse(Consumer<ResponseSpec> consumer) {
        this.responseConsumer = consumer;
        this.execute();
    }

    public AsyncCall onFailed(BiConsumer<Request, IOException> biConsumer) {
        this.failedBiConsumer = biConsumer;
        return this;
    }

    private void execute() {
        this.call.enqueue((Callback)new AsyncCallback(this));
    }

    void onResponse(HttpResponse httpResponse) {
        this.responseConsumer.accept(httpResponse);
    }

    void onSuccessful(HttpResponse httpResponse) {
        this.successConsumer.accept(httpResponse);
    }

    void onFailure(Request request, IOException e) {
        this.failedBiConsumer.accept(request, e);
    }
}

