/*
 * Decompiled with CFR 0.152.
 */
package com.cssw.kylin.tenant;

import com.baomidou.mybatisplus.core.metadata.TableFieldInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.extension.plugins.handler.TenantLineHandler;
import com.cssw.kylin.secure.AuthUtil;
import com.cssw.kylin.tenant.KylinTenantHolder;
import com.cssw.kylin.tenant.KylinTenantProperties;
import com.cssw.kylin.tenant.annotation.TableExclude;
import com.cssw.kylin.tool.util.Func;
import com.cssw.kylin.tool.util.SpringUtil;
import com.cssw.kylin.tool.util.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.StringValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.context.ApplicationContext;

public class KylinTenantHandler
implements TenantLineHandler,
SmartInitializingSingleton {
    private static final Logger log = LoggerFactory.getLogger(KylinTenantHandler.class);
    private final List<String> tenantTableList = new ArrayList<String>();
    private final List<String> excludeTableList = Arrays.asList("kylin_user", "kylin_dept", "kylin_role", "kylin_tenant", "act_de_model");
    private final KylinTenantProperties tenantProperties;

    public Expression getTenantId() {
        return new StringValue(Func.toStr((Object)AuthUtil.getTenantId(), (String)"000000"));
    }

    public String getTenantIdColumn() {
        return this.tenantProperties.getColumn();
    }

    public boolean ignoreTable(String tableName) {
        if (KylinTenantHolder.isIgnore().booleanValue()) {
            return true;
        }
        return !this.tenantTableList.contains(tableName) || !StringUtil.isNotBlank((CharSequence)AuthUtil.getTenantId());
    }

    public void afterSingletonsInstantiated() {
        ApplicationContext context = SpringUtil.getContext();
        if (this.tenantProperties.getAnnotationExclude().booleanValue() && context != null) {
            Map tables = context.getBeansWithAnnotation(TableExclude.class);
            List<String> excludeTables = this.tenantProperties.getExcludeTables();
            for (Object o : tables.values()) {
                TableExclude annotation = o.getClass().getAnnotation(TableExclude.class);
                String value = annotation.value();
                excludeTables.add(value);
            }
        }
        List tableInfos = TableInfoHelper.getTableInfos();
        block1: for (TableInfo tableInfo : tableInfos) {
            String tableName = tableInfo.getTableName();
            if (this.tenantProperties.getExcludeTables().contains(tableName) || this.excludeTableList.contains(tableName.toLowerCase()) || this.excludeTableList.contains(tableName.toUpperCase())) continue;
            List fieldList = tableInfo.getFieldList();
            for (TableFieldInfo fieldInfo : fieldList) {
                String column = fieldInfo.getColumn();
                if (!this.tenantProperties.getColumn().equals(column)) continue;
                this.tenantTableList.add(tableName);
                continue block1;
            }
        }
    }

    public KylinTenantHandler(KylinTenantProperties tenantProperties) {
        this.tenantProperties = tenantProperties;
    }
}

