/*
 * Decompiled with CFR 0.152.
 */
package com.cssw.kylin.tenant;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.ExceptionUtils;
import com.baomidou.mybatisplus.extension.plugins.handler.TenantLineHandler;
import com.baomidou.mybatisplus.extension.plugins.inner.TenantLineInnerInterceptor;
import com.cssw.kylin.secure.AuthUtil;
import com.cssw.kylin.tenant.KylinTenantProperties;
import com.cssw.kylin.tool.util.CollectionUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import net.sf.jsqlparser.expression.BinaryExpression;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Parenthesis;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.ItemsList;
import net.sf.jsqlparser.expression.operators.relational.MultiExpressionList;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.ParenthesisFromItem;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SubJoin;
import net.sf.jsqlparser.statement.update.Update;

public class KylinTenantInterceptor
extends TenantLineInnerInterceptor {
    private TenantLineHandler tenantLineHandler;
    private KylinTenantProperties tenantProperties;
    private List<String> adminTenantTables = Arrays.asList("kylin_top_menu", "kylin_dict_biz");

    public void setTenantLineHandler(TenantLineHandler tenantLineHandler) {
        super.setTenantLineHandler(tenantLineHandler);
        this.tenantLineHandler = tenantLineHandler;
    }

    protected void processInsert(Insert insert, int index, String sql, Object obj) {
        Select select;
        if (!this.tenantProperties.getEnhance().booleanValue()) {
            super.processInsert(insert, index, sql, obj);
            return;
        }
        if (this.tenantLineHandler.ignoreTable(insert.getTable().getName())) {
            return;
        }
        List columns = insert.getColumns();
        if (CollectionUtils.isEmpty((Collection)columns)) {
            return;
        }
        String tenantIdColumn = this.tenantLineHandler.getTenantIdColumn();
        if (columns.stream().map(Column::getColumnName).anyMatch(i -> i.equals(tenantIdColumn))) {
            return;
        }
        columns.add(new Column(tenantIdColumn));
        List duplicateUpdateColumns = insert.getDuplicateUpdateExpressionList();
        if (CollectionUtils.isNotEmpty((Collection)duplicateUpdateColumns)) {
            EqualsTo equalsTo = new EqualsTo();
            equalsTo.setLeftExpression((Expression)new StringValue(tenantIdColumn));
            equalsTo.setRightExpression(this.tenantLineHandler.getTenantId());
            duplicateUpdateColumns.add(equalsTo);
        }
        if ((select = insert.getSelect()) != null) {
            this.processInsertSelect(select.getSelectBody());
        } else if (insert.getItemsList() != null) {
            ItemsList itemsList = insert.getItemsList();
            if (itemsList instanceof MultiExpressionList) {
                ((MultiExpressionList)itemsList).getExpressionLists().forEach(el -> el.getExpressions().add(this.tenantLineHandler.getTenantId()));
            } else {
                ((ExpressionList)itemsList).getExpressions().add(this.tenantLineHandler.getTenantId());
            }
        } else {
            throw ExceptionUtils.mpe((String)"Failed to process multiple-table update, please exclude the tableName or statementId", (Object[])new Object[0]);
        }
    }

    protected void processPlainSelect(PlainSelect plainSelect) {
        List selectItems = plainSelect.getSelectItems();
        if (CollectionUtils.isNotEmpty((Collection)selectItems)) {
            selectItems.forEach(x$0 -> this.processSelectItem((SelectItem)x$0));
        }
        Expression where = plainSelect.getWhere();
        this.processWhereSubSelect(where);
        FromItem fromItem = plainSelect.getFromItem();
        List<Table> list = this.processFromItem(fromItem);
        List<Table> mainTables = new ArrayList<Table>(list);
        List joins = plainSelect.getJoins();
        if (CollectionUtils.isNotEmpty((Collection)joins)) {
            mainTables = this.processJoins(mainTables, joins);
        }
        if (CollectionUtils.isNotEmpty(mainTables) && !this.doTenantFilters(mainTables)) {
            plainSelect.setWhere(this.builderExpression(where, mainTables));
        }
    }

    protected void processUpdate(Update update, int index, String sql, Object obj) {
        Table table = update.getTable();
        if (this.tenantLineHandler.ignoreTable(table.getName())) {
            return;
        }
        if (this.doTenantFilter(table.getName())) {
            return;
        }
        update.setWhere((Expression)this.andExpression(table, update.getWhere()));
    }

    protected void processDelete(Delete delete, int index, String sql, Object obj) {
        Table table = delete.getTable();
        if (this.tenantLineHandler.ignoreTable(table.getName())) {
            return;
        }
        if (this.doTenantFilter(table.getName())) {
            return;
        }
        delete.setWhere((Expression)this.andExpression(table, delete.getWhere()));
    }

    protected BinaryExpression andExpression(Table table, Expression where) {
        EqualsTo equalsTo = new EqualsTo();
        Column leftExpression = this.getAliasColumn(table);
        Expression rightExpression = this.tenantLineHandler.getTenantId();
        if (this.doTenantFilter(table.getName())) {
            rightExpression = new StringValue("1");
            leftExpression = rightExpression;
        }
        equalsTo.setLeftExpression((Expression)leftExpression);
        equalsTo.setRightExpression(rightExpression);
        if (null != where) {
            if (where instanceof OrExpression) {
                return new AndExpression((Expression)equalsTo, (Expression)new Parenthesis(where));
            }
            return new AndExpression((Expression)equalsTo, where);
        }
        return equalsTo;
    }

    protected Expression builderExpression(Expression currentExpression, List<Table> tables) {
        if (CollectionUtils.isEmpty(tables)) {
            return currentExpression;
        }
        Expression tenantId = this.tenantLineHandler.getTenantId();
        List equalsTos = tables.stream().filter(x -> !this.tenantLineHandler.ignoreTable(x.getName())).filter(x -> !this.doTenantFilter(x.getName())).map(item -> new EqualsTo((Expression)this.getAliasColumn((Table)item), tenantId)).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(equalsTos)) {
            return currentExpression;
        }
        Expression injectExpression = (Expression)equalsTos.get(0);
        if (equalsTos.size() > 1) {
            for (int i = 1; i < equalsTos.size(); ++i) {
                injectExpression = new AndExpression(injectExpression, (Expression)equalsTos.get(i));
            }
        }
        if (currentExpression == null) {
            return injectExpression;
        }
        if (currentExpression instanceof OrExpression) {
            return new AndExpression((Expression)new Parenthesis(currentExpression), injectExpression);
        }
        return new AndExpression(currentExpression, injectExpression);
    }

    private List<Table> processFromItem(FromItem fromItem) {
        while (fromItem instanceof ParenthesisFromItem) {
            fromItem = ((ParenthesisFromItem)fromItem).getFromItem();
        }
        ArrayList<Table> mainTables = new ArrayList<Table>();
        if (fromItem instanceof Table) {
            Table fromTable = (Table)fromItem;
            mainTables.add(fromTable);
        } else if (fromItem instanceof SubJoin) {
            List<Table> tables = this.processSubJoin((SubJoin)fromItem);
            mainTables.addAll(tables);
        } else {
            this.processOtherFromItem(fromItem);
        }
        return mainTables;
    }

    private List<Table> processSubJoin(SubJoin subJoin) {
        List<Table> mainTables = new ArrayList<Table>();
        if (subJoin.getJoinList() != null) {
            List<Table> list = this.processFromItem(subJoin.getLeft());
            mainTables.addAll(list);
            mainTables = this.processJoins(mainTables, subJoin.getJoinList());
        }
        return mainTables;
    }

    private List<Table> processJoins(List<Table> mainTables, List<Join> joins) {
        Table mainTable = null;
        Table leftTable = null;
        if (mainTables == null) {
            mainTables = new ArrayList<Table>();
        } else if (mainTables.size() == 1) {
            leftTable = mainTable = mainTables.get(0);
        }
        LinkedList<List<Table>> onTableDeque = new LinkedList<List<Table>>();
        for (Join join : joins) {
            FromItem joinItem = join.getRightItem();
            List<Object> joinTables = null;
            if (joinItem instanceof Table) {
                joinTables = new ArrayList<Table>();
                joinTables.add((Table)joinItem);
            } else if (joinItem instanceof SubJoin) {
                joinTables = this.processSubJoin((SubJoin)joinItem);
            }
            if (joinTables != null) {
                LinkedList<Expression> onExpressions;
                Collection originOnExpressions;
                if (join.isSimple()) {
                    mainTables.addAll(joinTables);
                    continue;
                }
                Table joinTable = (Table)joinTables.get(0);
                List<Table> onTables = null;
                if (join.isRight()) {
                    mainTable = joinTable;
                    if (leftTable != null) {
                        onTables = Collections.singletonList(leftTable);
                    }
                } else if (join.isLeft()) {
                    onTables = Collections.singletonList(joinTable);
                } else if (join.isInner()) {
                    onTables = mainTable == null ? Collections.singletonList(joinTable) : Arrays.asList(mainTable, joinTable);
                    mainTable = null;
                }
                mainTables = new ArrayList<Table>();
                if (mainTable != null) {
                    mainTables.add(mainTable);
                }
                if ((originOnExpressions = join.getOnExpressions()).size() == 1 && onTables != null) {
                    onExpressions = new LinkedList<Expression>();
                    onExpressions.add(this.builderExpression((Expression)originOnExpressions.iterator().next(), onTables));
                    join.setOnExpressions(onExpressions);
                    leftTable = joinTable;
                    continue;
                }
                onTableDeque.push(onTables);
                if (originOnExpressions.size() > 1) {
                    onExpressions = new LinkedList();
                    for (Expression originOnExpression : originOnExpressions) {
                        List currentTableList = (List)onTableDeque.poll();
                        if (CollectionUtils.isEmpty((Collection)currentTableList)) {
                            onExpressions.add(originOnExpression);
                            continue;
                        }
                        onExpressions.add(this.builderExpression(originOnExpression, currentTableList));
                    }
                    join.setOnExpressions(onExpressions);
                }
                leftTable = joinTable;
                continue;
            }
            this.processOtherFromItem(joinItem);
            leftTable = null;
        }
        return mainTables;
    }

    public boolean doTenantFilter(String tableName) {
        return AuthUtil.isAdministrator() && !this.adminTenantTables.contains(tableName);
    }

    public boolean doTenantFilters(List<Table> tables) {
        List tableNames = tables.stream().map(Table::getName).collect(Collectors.toList());
        return AuthUtil.isAdministrator() && !CollectionUtil.containsAny(this.adminTenantTables, tableNames);
    }

    public TenantLineHandler getTenantLineHandler() {
        return this.tenantLineHandler;
    }

    public KylinTenantProperties getTenantProperties() {
        return this.tenantProperties;
    }

    public List<String> getAdminTenantTables() {
        return this.adminTenantTables;
    }

    public void setTenantProperties(KylinTenantProperties tenantProperties) {
        this.tenantProperties = tenantProperties;
    }

    public void setAdminTenantTables(List<String> adminTenantTables) {
        this.adminTenantTables = adminTenantTables;
    }

    public String toString() {
        return "KylinTenantInterceptor(super=" + super.toString() + ", tenantLineHandler=" + this.getTenantLineHandler() + ", tenantProperties=" + this.getTenantProperties() + ", adminTenantTables=" + this.getAdminTenantTables() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KylinTenantInterceptor)) {
            return false;
        }
        KylinTenantInterceptor other = (KylinTenantInterceptor)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TenantLineHandler this$tenantLineHandler = this.getTenantLineHandler();
        TenantLineHandler other$tenantLineHandler = other.getTenantLineHandler();
        if (this$tenantLineHandler == null ? other$tenantLineHandler != null : !this$tenantLineHandler.equals(other$tenantLineHandler)) {
            return false;
        }
        KylinTenantProperties this$tenantProperties = this.getTenantProperties();
        KylinTenantProperties other$tenantProperties = other.getTenantProperties();
        if (this$tenantProperties == null ? other$tenantProperties != null : !((Object)this$tenantProperties).equals(other$tenantProperties)) {
            return false;
        }
        List<String> this$adminTenantTables = this.getAdminTenantTables();
        List<String> other$adminTenantTables = other.getAdminTenantTables();
        return !(this$adminTenantTables == null ? other$adminTenantTables != null : !((Object)this$adminTenantTables).equals(other$adminTenantTables));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KylinTenantInterceptor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        TenantLineHandler $tenantLineHandler = this.getTenantLineHandler();
        result = result * 59 + ($tenantLineHandler == null ? 43 : $tenantLineHandler.hashCode());
        KylinTenantProperties $tenantProperties = this.getTenantProperties();
        result = result * 59 + ($tenantProperties == null ? 43 : ((Object)$tenantProperties).hashCode());
        List<String> $adminTenantTables = this.getAdminTenantTables();
        result = result * 59 + ($adminTenantTables == null ? 43 : ((Object)$adminTenantTables).hashCode());
        return result;
    }
}

