/*
 * Decompiled with CFR 0.152.
 */
package com.cssw.kylin.tenant.config;

import com.baomidou.mybatisplus.extension.plugins.handler.TenantLineHandler;
import com.baomidou.mybatisplus.extension.plugins.inner.TenantLineInnerInterceptor;
import com.cssw.kylin.mybatis.config.MybatisPlusConfiguration;
import com.cssw.kylin.tenant.KylinTenantHandler;
import com.cssw.kylin.tenant.KylinTenantId;
import com.cssw.kylin.tenant.KylinTenantInterceptor;
import com.cssw.kylin.tenant.KylinTenantProperties;
import com.cssw.kylin.tenant.TenantId;
import com.cssw.kylin.tenant.aspect.KylinTenantAspect;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;

@AutoConfiguration(before={MybatisPlusConfiguration.class})
@EnableConfigurationProperties(value={KylinTenantProperties.class})
public class TenantConfiguration {
    @Bean
    @Primary
    public TenantLineHandler kylinTenantHandler(KylinTenantProperties tenantProperties) {
        return new KylinTenantHandler(tenantProperties);
    }

    @Bean
    @Primary
    public TenantLineInnerInterceptor tenantLineInnerInterceptor(TenantLineHandler tenantHandler, KylinTenantProperties tenantProperties) {
        KylinTenantInterceptor tenantInterceptor = new KylinTenantInterceptor();
        tenantInterceptor.setTenantLineHandler(tenantHandler);
        tenantInterceptor.setTenantProperties(tenantProperties);
        return tenantInterceptor;
    }

    @Bean
    @ConditionalOnMissingBean(value={TenantId.class})
    public TenantId tenantId() {
        return new KylinTenantId();
    }

    @Bean
    public KylinTenantAspect kylinTenantAspect() {
        return new KylinTenantAspect();
    }
}

