/*
 * Decompiled with CFR 0.152.
 */
package com.cssw.kylin.tenant.config;

import com.alibaba.druid.spring.boot.autoconfigure.DruidDataSourceAutoConfigure;
import com.baomidou.dynamic.datasource.DynamicRoutingDataSource;
import com.baomidou.dynamic.datasource.aop.DynamicDataSourceAnnotationAdvisor;
import com.baomidou.dynamic.datasource.aop.DynamicDataSourceAnnotationInterceptor;
import com.baomidou.dynamic.datasource.creator.DataSourceCreator;
import com.baomidou.dynamic.datasource.creator.DruidDataSourceCreator;
import com.baomidou.dynamic.datasource.processor.DsHeaderProcessor;
import com.baomidou.dynamic.datasource.processor.DsProcessor;
import com.baomidou.dynamic.datasource.processor.DsSessionProcessor;
import com.baomidou.dynamic.datasource.processor.DsSpelExpressionProcessor;
import com.baomidou.dynamic.datasource.provider.DynamicDataSourceProvider;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DataSourceProperty;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DynamicDataSourceAutoConfiguration;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DynamicDataSourceCreatorAutoConfiguration;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DynamicDataSourceProperties;
import com.cssw.kylin.tenant.dynamic.DsTenantIdProcessor;
import com.cssw.kylin.tenant.dynamic.TenantDataSourceAnnotationInterceptor;
import com.cssw.kylin.tenant.dynamic.TenantDataSourceGlobalAdvisor;
import com.cssw.kylin.tenant.dynamic.TenantDataSourceGlobalInterceptor;
import com.cssw.kylin.tenant.dynamic.TenantDataSourceHolder;
import com.cssw.kylin.tenant.dynamic.TenantDataSourceJdbcProvider;
import javax.sql.DataSource;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Role;
import org.springframework.core.annotation.Order;
import org.springframework.jdbc.core.JdbcTemplate;

@EnableConfigurationProperties(value={DataSourceProperties.class, DynamicDataSourceProperties.class})
@AutoConfiguration(before={DruidDataSourceAutoConfigure.class, DynamicDataSourceAutoConfiguration.class})
@Import(value={DynamicDataSourceCreatorAutoConfiguration.class})
@ConditionalOnProperty(value={"kylin.tenant.dynamic-datasource"}, havingValue="true")
public class TenantDataSourceConfiguration {
    @Bean
    @Primary
    public DynamicDataSourceProvider dynamicDataSourceProvider(DataSourceProperties dataSourceProperties, DynamicDataSourceProperties dynamicDataSourceProperties) {
        String driverClassName = dataSourceProperties.getDriverClassName();
        String url = dataSourceProperties.getUrl();
        String username = dataSourceProperties.getUsername();
        String password = dataSourceProperties.getPassword();
        DataSourceProperty master = (DataSourceProperty)dynamicDataSourceProperties.getDatasource().get(dynamicDataSourceProperties.getPrimary());
        if (master != null) {
            driverClassName = master.getDriverClassName();
            url = master.getUrl();
            username = master.getUsername();
            password = master.getPassword();
        }
        return new TenantDataSourceJdbcProvider(dynamicDataSourceProperties, driverClassName, url, username, password);
    }

    @Bean
    @Primary
    public DataSource dataSource(DynamicDataSourceProvider dynamicDataSourceProvider, DynamicDataSourceProperties dynamicDataSourceProperties) {
        DynamicRoutingDataSource dataSource = new DynamicRoutingDataSource();
        dataSource.setPrimary(dynamicDataSourceProperties.getPrimary());
        dataSource.setStrict(dynamicDataSourceProperties.getStrict());
        dataSource.setStrategy(dynamicDataSourceProperties.getStrategy());
        dataSource.setProvider(dynamicDataSourceProvider);
        dataSource.setP6spy(dynamicDataSourceProperties.getP6spy());
        dataSource.setSeata(dynamicDataSourceProperties.getSeata());
        return dataSource;
    }

    @Bean
    @ConditionalOnMissingBean
    public TenantDataSourceAnnotationInterceptor tenantDataSourceAnnotationInterceptor(DsProcessor dsProcessor, DynamicDataSourceProperties dynamicDataSourceProperties) {
        return new TenantDataSourceAnnotationInterceptor(dynamicDataSourceProperties.isAllowedPublicOnly(), dsProcessor);
    }

    @Bean
    @ConditionalOnMissingBean
    @Role(value=2)
    public DynamicDataSourceAnnotationAdvisor dynamicDatasourceAnnotationAdvisor(TenantDataSourceAnnotationInterceptor tenantDataSourceAnnotationInterceptor, DynamicDataSourceProperties dynamicDataSourceProperties) {
        DynamicDataSourceAnnotationAdvisor advisor = new DynamicDataSourceAnnotationAdvisor((DynamicDataSourceAnnotationInterceptor)tenantDataSourceAnnotationInterceptor);
        advisor.setOrder(dynamicDataSourceProperties.getOrder().intValue());
        return advisor;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(value={"kylin.tenant.dynamic-global"}, havingValue="true")
    public TenantDataSourceGlobalInterceptor tenantDataSourceGlobalInterceptor() {
        return new TenantDataSourceGlobalInterceptor();
    }

    @Bean
    @ConditionalOnMissingBean
    @Role(value=2)
    @ConditionalOnProperty(value={"kylin.tenant.dynamic-global"}, havingValue="true")
    public TenantDataSourceGlobalAdvisor tenantDataSourceGlobalAdvisor(TenantDataSourceGlobalInterceptor tenantDataSourceGlobalInterceptor, DynamicDataSourceProperties dynamicDataSourceProperties) {
        TenantDataSourceGlobalAdvisor advisor = new TenantDataSourceGlobalAdvisor(tenantDataSourceGlobalInterceptor);
        advisor.setOrder(dynamicDataSourceProperties.getOrder() + 1);
        return advisor;
    }

    @Bean
    @ConditionalOnMissingBean
    public DsProcessor dsProcessor() {
        DsHeaderProcessor headerProcessor = new DsHeaderProcessor();
        DsSessionProcessor sessionProcessor = new DsSessionProcessor();
        DsTenantIdProcessor tenantIdProcessor = new DsTenantIdProcessor();
        DsSpelExpressionProcessor spelExpressionProcessor = new DsSpelExpressionProcessor();
        headerProcessor.setNextProcessor((DsProcessor)sessionProcessor);
        sessionProcessor.setNextProcessor((DsProcessor)tenantIdProcessor);
        tenantIdProcessor.setNextProcessor((DsProcessor)spelExpressionProcessor);
        return headerProcessor;
    }

    @Order
    @AutoConfiguration
    @ConditionalOnProperty(value={"kylin.tenant.dynamic-global"}, havingValue="true")
    public static class TenantDataSourceGlobalConfiguration
    implements SmartInitializingSingleton {
        private final TenantDataSourceGlobalInterceptor tenantDataSourceGlobalInterceptor;
        private final DataSource dataSource;
        private final DruidDataSourceCreator dataSourceCreator;
        private final JdbcTemplate jdbcTemplate;

        public void afterSingletonsInstantiated() {
            TenantDataSourceHolder tenantDataSourceHolder = new TenantDataSourceHolder(this.dataSource, (DataSourceCreator)this.dataSourceCreator, this.jdbcTemplate);
            this.tenantDataSourceGlobalInterceptor.setHolder(tenantDataSourceHolder);
        }

        public TenantDataSourceGlobalConfiguration(TenantDataSourceGlobalInterceptor tenantDataSourceGlobalInterceptor, DataSource dataSource, DruidDataSourceCreator dataSourceCreator, JdbcTemplate jdbcTemplate) {
            this.tenantDataSourceGlobalInterceptor = tenantDataSourceGlobalInterceptor;
            this.dataSource = dataSource;
            this.dataSourceCreator = dataSourceCreator;
            this.jdbcTemplate = jdbcTemplate;
        }
    }

    @Order
    @AutoConfiguration
    @ConditionalOnProperty(value={"kylin.tenant.dynamic-datasource"}, havingValue="true")
    public static class TenantDataSourceAnnotationConfiguration
    implements SmartInitializingSingleton {
        private final TenantDataSourceAnnotationInterceptor tenantDataSourceAnnotationInterceptor;
        private final DataSource dataSource;
        private final DruidDataSourceCreator dataSourceCreator;
        private final JdbcTemplate jdbcTemplate;

        public void afterSingletonsInstantiated() {
            TenantDataSourceHolder tenantDataSourceHolder = new TenantDataSourceHolder(this.dataSource, (DataSourceCreator)this.dataSourceCreator, this.jdbcTemplate);
            this.tenantDataSourceAnnotationInterceptor.setHolder(tenantDataSourceHolder);
        }

        public TenantDataSourceAnnotationConfiguration(TenantDataSourceAnnotationInterceptor tenantDataSourceAnnotationInterceptor, DataSource dataSource, DruidDataSourceCreator dataSourceCreator, JdbcTemplate jdbcTemplate) {
            this.tenantDataSourceAnnotationInterceptor = tenantDataSourceAnnotationInterceptor;
            this.dataSource = dataSource;
            this.dataSourceCreator = dataSourceCreator;
            this.jdbcTemplate = jdbcTemplate;
        }
    }
}

