/*
 * Decompiled with CFR 0.152.
 */
package com.cssw.kylin.tenant.dynamic;

import com.baomidou.dynamic.datasource.toolkit.DynamicDataSourceContextHolder;
import com.cssw.kylin.secure.AuthUtil;
import com.cssw.kylin.tenant.dynamic.TenantDataSourceHolder;
import com.cssw.kylin.tenant.exception.TenantDataSourceException;
import com.cssw.kylin.tool.util.StringUtil;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class TenantDataSourceGlobalInterceptor
implements MethodInterceptor {
    private TenantDataSourceHolder holder;

    public Object invoke(MethodInvocation invocation) throws Throwable {
        String tenantId = AuthUtil.getTenantId();
        try {
            if (StringUtil.isNotBlank((CharSequence)tenantId)) {
                this.holder.handleDataSource(tenantId);
                DynamicDataSourceContextHolder.push((String)tenantId);
            }
            Object object = invocation.proceed();
            return object;
        }
        catch (Exception exception) {
            throw new TenantDataSourceException(exception.getMessage());
        }
        finally {
            if (StringUtil.isNotBlank((CharSequence)tenantId)) {
                DynamicDataSourceContextHolder.poll();
            }
        }
    }

    public void setHolder(TenantDataSourceHolder holder) {
        this.holder = holder;
    }
}

