/*
 * Decompiled with CFR 0.152.
 */
package com.cssw.kylin.tenant.dynamic;

import com.baomidou.dynamic.datasource.DynamicRoutingDataSource;
import com.baomidou.dynamic.datasource.creator.DataSourceCreator;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DataSourceProperty;
import com.cssw.kylin.cache.CacheUtil;
import com.cssw.kylin.tenant.dynamic.TenantDataSource;
import com.cssw.kylin.tool.util.StringUtil;
import java.util.Set;
import javax.sql.DataSource;
import org.springframework.beans.BeanUtils;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class TenantDataSourceHolder {
    private final DataSource dataSource;
    private final DataSourceCreator dataSourceCreator;
    private final JdbcTemplate jdbcTemplate;

    public void handleDataSource(String tenantId) {
        TenantDataSource tenantDataSource;
        DynamicRoutingDataSource ds = (DynamicRoutingDataSource)this.dataSource;
        Set keys = ds.getCurrentDataSources().keySet();
        if (!keys.contains(tenantId) && (tenantDataSource = this.getDataSource(tenantId)) != null) {
            DataSourceProperty dataSourceProperty = new DataSourceProperty();
            BeanUtils.copyProperties((Object)tenantDataSource, (Object)dataSourceProperty);
            dataSourceProperty.setLazy(Boolean.FALSE);
            DataSource dataSource = this.dataSourceCreator.createDataSource(dataSourceProperty);
            ds.addDataSource(tenantId, dataSource);
        }
    }

    private Boolean existDataSource(String tenantId) {
        Boolean exist = (Boolean)CacheUtil.get((String)"kylin:datasource", (String)"tenant:exist:", (Object)tenantId, Boolean.class, (Boolean)Boolean.FALSE);
        if (exist == null) {
            TenantDataSource tenantDataSource = (TenantDataSource)this.jdbcTemplate.queryForObject("select datasource_id from kylin_tenant WHERE is_deleted = 0 AND tenant_id = ?", (Object[])new String[]{tenantId}, (RowMapper)new BeanPropertyRowMapper(TenantDataSource.class));
            exist = tenantDataSource != null && StringUtil.isNotBlank((CharSequence)tenantDataSource.getDatasourceId()) ? Boolean.TRUE : Boolean.FALSE;
            CacheUtil.put((String)"kylin:datasource", (String)"tenant:exist:", (Object)tenantId, (Object)exist, (Boolean)Boolean.FALSE);
        }
        return exist;
    }

    private TenantDataSource getDataSource(String tenantId) {
        if (!this.existDataSource(tenantId).booleanValue()) {
            return null;
        }
        TenantDataSource tenantDataSource = (TenantDataSource)CacheUtil.get((String)"kylin:datasource", (String)"tenant:id:", (Object)tenantId, TenantDataSource.class, (Boolean)Boolean.FALSE);
        if (tenantDataSource == null) {
            tenantDataSource = (TenantDataSource)this.jdbcTemplate.queryForObject("SELECT tenant_id as tenantId, driver_class as driverClass, url, username, password from kylin_tenant tenant LEFT JOIN kylin_datasource datasource ON tenant.datasource_id = datasource.id WHERE tenant.is_deleted = 0 AND tenant.tenant_id = ?", (Object[])new String[]{tenantId}, (RowMapper)new BeanPropertyRowMapper(TenantDataSource.class));
            if (tenantDataSource != null && StringUtil.isNoneBlank((CharSequence[])new CharSequence[]{tenantDataSource.getTenantId(), tenantDataSource.getDriverClass(), tenantDataSource.getUrl(), tenantDataSource.getUsername(), tenantDataSource.getPassword()})) {
                CacheUtil.put((String)"kylin:datasource", (String)"tenant:id:", (Object)tenantId, (Object)tenantDataSource, (Boolean)Boolean.FALSE);
            } else {
                tenantDataSource = null;
            }
        }
        return tenantDataSource;
    }

    public TenantDataSourceHolder(DataSource dataSource, DataSourceCreator dataSourceCreator, JdbcTemplate jdbcTemplate) {
        this.dataSource = dataSource;
        this.dataSourceCreator = dataSourceCreator;
        this.jdbcTemplate = jdbcTemplate;
    }
}

