/*
 * Decompiled with CFR 0.152.
 */
package com.cssw.kylin.tenant.dynamic;

import com.baomidou.dynamic.datasource.provider.AbstractJdbcDataSourceProvider;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DataSourceProperty;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DynamicDataSourceProperties;
import com.cssw.kylin.tool.util.StringUtil;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;

public class TenantDataSourceJdbcProvider
extends AbstractJdbcDataSourceProvider {
    private final String driverClassName;
    private final String url;
    private final String username;
    private final String password;
    private final DynamicDataSourceProperties dynamicDataSourceProperties;

    public TenantDataSourceJdbcProvider(DynamicDataSourceProperties dynamicDataSourceProperties, String driverClassName, String url, String username, String password) {
        super(driverClassName, url, username, password);
        this.dynamicDataSourceProperties = dynamicDataSourceProperties;
        this.driverClassName = driverClassName;
        this.url = url;
        this.username = username;
        this.password = password;
    }

    protected Map<String, DataSourceProperty> executeStmt(Statement statement) throws SQLException {
        HashMap<String, DataSourceProperty> map = new HashMap<String, DataSourceProperty>(16);
        DataSourceProperty masterProperty = new DataSourceProperty();
        masterProperty.setDriverClassName(this.driverClassName);
        masterProperty.setUrl(this.url);
        masterProperty.setUsername(this.username);
        masterProperty.setPassword(this.password);
        masterProperty.setDruid(this.dynamicDataSourceProperties.getDruid());
        map.put(this.dynamicDataSourceProperties.getPrimary(), masterProperty);
        Map datasource = this.dynamicDataSourceProperties.getDatasource();
        if (datasource.size() > 0) {
            map.putAll(datasource);
        }
        ResultSet rs = statement.executeQuery("SELECT tenant_id as tenantId, driver_class as driverClass, url, username, password from kylin_tenant tenant LEFT JOIN kylin_datasource datasource ON tenant.datasource_id = datasource.id WHERE tenant.is_deleted = 0");
        while (rs.next()) {
            String tenantId = rs.getString("tenantId");
            String driver = rs.getString("driverClass");
            String url = rs.getString("url");
            String username = rs.getString("username");
            String password = rs.getString("password");
            if (!StringUtil.isNoneBlank((CharSequence[])new CharSequence[]{tenantId, driver, url, username, password})) continue;
            DataSourceProperty jdbcProperty = new DataSourceProperty();
            jdbcProperty.setDriverClassName(driver);
            jdbcProperty.setUrl(url);
            jdbcProperty.setUsername(username);
            jdbcProperty.setPassword(password);
            jdbcProperty.setDruid(this.dynamicDataSourceProperties.getDruid());
            map.put(tenantId, jdbcProperty);
        }
        return map;
    }
}

