package com.ydn.asr.uidialog;

import com.ydn.asr.core.recog.Recognizer;
import com.ydn.asr.core.recog.listener.ChainRecogListener;

import java.util.Map;

/**
 * @author Feng Chen
 */
public class DigitalDialogInput {

    private Recognizer recognizer;

    private ChainRecogListener listener;

    private int code;

    private Map<String, Object> startParams;

    public DigitalDialogInput(Recognizer recognizer, ChainRecogListener listener, Map<String, Object> startParams) {
        if (recognizer == null) {
            throw new NullPointerException("myRecogizer param is null");
        }
        if (listener == null) {
            throw new NullPointerException("listener param is null");
        }
        if (startParams == null) {
            throw new NullPointerException("startParams param is null");
        }

        this.recognizer = recognizer;
        this.listener = listener;
        this.startParams = startParams;
    }

    public Recognizer getRecognizer() {
        return recognizer;
    }

    public ChainRecogListener getListener() {
        return listener;
    }

    public Map<String, Object> getStartParams() {
        return startParams;
    }

}
