/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.jsrv.config.db;

import com.alibaba.druid.filter.Filter;
import com.alibaba.druid.filter.stat.StatFilter;
import com.alibaba.druid.wall.WallFilter;
import com.ydn.jsrv.config.yaml.GlobalYamlConfiguration;
import com.ydn.jsrv.exception.JsrvException;
import com.ydn.jsrv.plugin.Plugins;
import com.ydn.jsrv.plugin.activerecord.ActiveRecordPlugin;
import com.ydn.jsrv.plugin.activerecord.Table;
import com.ydn.jsrv.plugin.druid.DruidPlugin;
import com.ydn.jsrv.util.PathUtil;
import com.ydn.jsrv.util.StrUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DBConfig {
    private static final String url = "url";
    private static final String username = "username";
    private static final String pwd = "pwd";
    private static final String dbtype = "dbtype";
    private static final String showsql = "showsql";
    private static final String wallfilter = "wallfilter";
    private static final String statfilter = "statfilter";
    public static final String mappingName = "mapping.xml";

    public static void load(Plugins plugins) {
        List<String> dbSources = GlobalYamlConfiguration.getDbSoueces();
        if (dbSources == null || dbSources.size() == 0) {
            return;
        }
        for (String dbSource : dbSources) {
            DruidPlugin druidPlugin = new DruidPlugin(GlobalYamlConfiguration.getDbValue(dbSource, url), GlobalYamlConfiguration.getDbValue(dbSource, username), GlobalYamlConfiguration.getDbValue(dbSource, pwd));
            if (Boolean.valueOf(GlobalYamlConfiguration.getDbValue(dbSource, wallfilter)).booleanValue()) {
                WallFilter wallFilter = new WallFilter();
                wallFilter.setDbType(GlobalYamlConfiguration.getDbValue(dbSource, dbtype));
                druidPlugin.addFilter((Filter)wallFilter);
            }
            if (Boolean.valueOf(GlobalYamlConfiguration.getDbValue(dbSource, statfilter)).booleanValue()) {
                druidPlugin.addFilter((Filter)new StatFilter());
            }
            plugins.add(druidPlugin);
            ActiveRecordPlugin arp = new ActiveRecordPlugin(dbSource, druidPlugin);
            arp.setTransactionLevel(2);
            arp.setShowSql(Boolean.valueOf(showsql));
            DBConfig.parseTableList(arp, dbSource);
            plugins.add(arp);
        }
    }

    private static List<Table> parseTableList(ActiveRecordPlugin arp, String resource) {
        File file = DBConfig.getFile(resource + "_" + mappingName);
        List<Map<String, String>> mappings = DBConfig.paser(file);
        for (Map<String, String> mapping : mappings) {
            try {
                arp.addMapping(mapping.get("name"), mapping.get("key"), Class.forName(mapping.get("bean")));
            }
            catch (ClassNotFoundException e) {
                throw new JsrvException("class form name error :" + mapping.get("bean"), e);
            }
        }
        return null;
    }

    private static File getFile(String _fileName) {
        String home = System.getProperty("JSRV_HOME");
        if (StrUtil.isBlank(home)) {
            home = PathUtil.getClassRootPath();
        }
        File file = new File(home + File.separator + _fileName);
        return file;
    }

    public static List<Map<String, String>> paser(File file) {
        ArrayList<Map<String, String>> lists = new ArrayList<Map<String, String>>();
        HashMap<String, String> map = null;
        try {
            DocumentBuilder newDocumentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = null;
            doc = newDocumentBuilder.parse(file);
            Element root = doc.getDocumentElement();
            NodeList tableList = root.getElementsByTagName("table");
            for (int i = 0; i < tableList.getLength(); ++i) {
                map = new HashMap<String, String>();
                Node node = tableList.item(i);
                NamedNodeMap modeMap = node.getAttributes();
                map.put("name", modeMap.getNamedItem("name").getNodeValue());
                map.put("key", modeMap.getNamedItem("key").getNodeValue());
                map.put("bean", modeMap.getNamedItem("bean").getNodeValue());
                lists.add(map);
            }
        }
        catch (SAXException e) {
            throw new JsrvException(" db xml paser  sax error", e);
        }
        catch (IOException e) {
            throw new JsrvException(" db xml paser io error", e);
        }
        catch (ParserConfigurationException e) {
            throw new JsrvException(" db xml paser paser config error", e);
        }
        return lists;
    }
}

