/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.jsrv.config.yaml;

import com.ydn.jsrv.util.PathUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.yaml.snakeyaml.Yaml;

public class YamlConfiguration {
    private static final String yamlConfig = "jsrv.yaml";
    protected static final String dbConfigSource = "dbconfig.resources";
    protected Map<String, String> allData = new HashMap<String, String>();
    protected List<String> dbSource = new ArrayList<String>();
    protected volatile boolean builded = false;

    public void buildPropFile() {
        if (this.isBuilded()) {
            return;
        }
        Yaml yaml = new Yaml();
        String home = PathUtil.getConfigPath();
        File file = new File(home + File.separator + yamlConfig);
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        for (Map map : yaml.loadAll((InputStream)inputStream)) {
            this.iteratorYml(map, null);
        }
        this.builded = true;
    }

    public void iteratorYml(Map map, String key) {
        for (Map.Entry entry : map.entrySet()) {
            Object key2 = entry.getKey();
            Object value = entry.getValue();
            if (dbConfigSource.equals(key)) {
                this.parseDbs(map);
            }
            if (value instanceof LinkedHashMap) {
                if (key == null) {
                    this.iteratorYml((Map)value, key2.toString());
                    continue;
                }
                this.iteratorYml((Map)value, key + "." + key2.toString());
                continue;
            }
            if (key == null) {
                this.allData.put(key2.toString(), value.toString());
            }
            if (key == null) continue;
            this.allData.put(key + "." + key2.toString(), value.toString());
        }
    }

    private void parseDbs(Map map) {
        if (this.dbSource.size() > 0) {
            return;
        }
        map.forEach((key, value) -> this.dbSource.add(key.toString()));
    }

    public boolean isBuilded() {
        return this.builded;
    }
}

