/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.jsrv.core;

import com.ydn.jsrv.boot.JSrvBooter;
import com.ydn.jsrv.config.db.DBConfig;
import com.ydn.jsrv.config.yaml.GlobalYamlConfiguration;
import com.ydn.jsrv.core.JSrvFilter;
import com.ydn.jsrv.handler.Handlers;
import com.ydn.jsrv.interceptor.Interceptors;
import com.ydn.jsrv.log.Log;
import com.ydn.jsrv.log.LogManager;
import com.ydn.jsrv.plugin.IPlugin;
import com.ydn.jsrv.plugin.Plugins;
import com.ydn.jsrv.plugin.cron4j.Cron4jConfig;
import com.ydn.jsrv.plugin.cron4j.Cron4jPlugin;
import com.ydn.jsrv.plugin.monitor.MonitorConfig;
import com.ydn.jsrv.plugin.monitor.MonitorPlugin;
import com.ydn.jsrv.route.Routes;
import com.ydn.jsrv.util.StrUtil;
import java.util.List;

class Config {
    private static final Routes routes = new Routes(){

        @Override
        public void config() {
        }
    };
    private static final Plugins plugins = new Plugins();
    private static final Interceptors interceptors = new Interceptors();
    private static final Handlers handlers = new Handlers();
    private static Log log;

    private Config() {
    }

    static void configJBooter(JSrvBooter jsrvBooter) {
        Config.initLogFactory();
        jsrvBooter.configInterceptor(interceptors);
        jsrvBooter.configRoute(routes);
        jsrvBooter.configHandler(handlers);
        Config.initPluginConfig();
    }

    public static final Routes getRoutes() {
        return routes;
    }

    public static final Plugins getPlugins() {
        return plugins;
    }

    private static void initPluginConfig() {
        Config.initDbConfig();
        Config.initTask();
        Config.initMonitor();
    }

    private static void initDbConfig() {
        DBConfig.load(plugins);
    }

    private static void initTask() {
        Cron4jConfig cron4jConfig = new Cron4jConfig();
        if (StrUtil.isBlank(cron4jConfig.getTaskNames())) {
            return;
        }
        plugins.add(new Cron4jPlugin(cron4jConfig));
    }

    private static void initMonitor() {
        if (MonitorConfig.startMonitor()) {
            plugins.add(new MonitorPlugin());
        }
    }

    public static Handlers getHandlers() {
        return handlers;
    }

    protected static void startPlugins() {
        List<IPlugin> pluginList = plugins.getPluginList();
        if (pluginList == null) {
            return;
        }
        for (IPlugin plugin : pluginList) {
            try {
                if (plugin.start()) continue;
                String message = "Plugin start error: " + plugin.getClass().getName();
                log.error(message);
                throw new RuntimeException(message);
            }
            catch (Exception e) {
                String message = "Plugin start error: " + plugin.getClass().getName() + ". \n" + e.getMessage();
                log.error(message, e);
                throw new RuntimeException(message, e);
            }
        }
    }

    private static void initLogFactory() {
        LogManager.me().init();
        log = Log.getLog(Config.class);
        JSrvFilter.initLog();
    }

    private static void initYaml() {
        if (!GlobalYamlConfiguration.me().isBuilded()) {
            GlobalYamlConfiguration.me().buildPropFile();
        }
    }
}

