/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.jsrv.core;

import com.ydn.jsrv.core.converter.TypeConverter;
import com.ydn.jsrv.plugin.activerecord.ActiveRecordException;
import com.ydn.jsrv.plugin.activerecord.Model;
import com.ydn.jsrv.plugin.activerecord.Table;
import com.ydn.jsrv.plugin.activerecord.TableMapping;
import com.ydn.jsrv.util.MapTools;
import com.ydn.jsrv.util.StrUtil;
import java.lang.reflect.Method;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class Injector {
    private static <T> T createInstance(Class<T> objClass) {
        try {
            return objClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T injectModel(Class<T> modelClass, HttpServletRequest request, boolean skipConvertError) {
        String modelName = modelClass.getSimpleName();
        return Injector.injectModel(modelClass, StrUtil.firstCharToLowerCase(modelName), request, skipConvertError);
    }

    public static final <T> T injectBean(Class<T> beanClass, HttpServletRequest request, boolean skipConvertError) {
        Method[] methods;
        T bean = Injector.createInstance(beanClass);
        TypeConverter converter = TypeConverter.me();
        Map parasMap = request.getParameterMap();
        for (Method method : methods = beanClass.getMethods()) {
            String attrName;
            Class<?>[] types;
            String methodName = method.getName();
            if (!methodName.startsWith("set") || methodName.length() <= 3 || (types = method.getParameterTypes()).length != 1 || !parasMap.containsKey(attrName = StrUtil.firstCharToLowerCase(methodName.substring(3)))) continue;
            try {
                String paraValue = request.getParameter(attrName);
                Object value = paraValue != null ? converter.convert(types[0], paraValue) : null;
                method.invoke(bean, value);
            }
            catch (Exception e) {
                if (skipConvertError) continue;
                throw new RuntimeException(e);
            }
        }
        return bean;
    }

    public static final <T> T injectModel(Class<T> modelClass, String modelName, HttpServletRequest request, boolean skipConvertError) {
        T temp = Injector.createInstance(modelClass);
        if (!(temp instanceof Model)) {
            throw new IllegalArgumentException("getModel only support class of Model, using getBean for other class.");
        }
        Model model = (Model)temp;
        Table table = TableMapping.me().getTable(model.getClass());
        if (table == null) {
            throw new ActiveRecordException("The Table mapping of model: " + modelClass.getName() + " not exists or the ActiveRecordPlugin not start.");
        }
        String modelNameAndDot = StrUtil.notBlank(modelName) ? modelName + "." : null;
        Map parasMap = request.getParameterMap();
        TypeConverter converter = TypeConverter.me();
        for (Map.Entry entry : parasMap.entrySet()) {
            String attrName;
            String paraName = (String)entry.getKey();
            if (modelNameAndDot != null) {
                if (!paraName.startsWith(modelNameAndDot)) continue;
                attrName = paraName.substring(modelNameAndDot.length());
            } else {
                attrName = paraName;
            }
            Class<?> colType = table.getColumnType(attrName);
            if (colType == null) {
                if (skipConvertError) continue;
                throw new ActiveRecordException("The model attribute " + attrName + " is not exists.");
            }
            try {
                String[] paraValueArray = (String[])entry.getValue();
                String paraValue = paraValueArray != null && paraValueArray.length > 0 ? paraValueArray[0] : null;
                Object value = paraValue != null ? converter.convert(colType, paraValue) : null;
                model.set(attrName, value);
            }
            catch (Exception e) {
                if (skipConvertError) continue;
                throw new RuntimeException("Can not convert parameter: " + paraName, e);
            }
        }
        return (T)model;
    }

    public static final <T> T injectModel(Class<T> beanClass, Map map) {
        Method[] methods;
        T bean = Injector.createInstance(beanClass);
        TypeConverter converter = TypeConverter.me();
        for (Method method : methods = beanClass.getMethods()) {
            String attrName;
            Class<?>[] types;
            String methodName = method.getName();
            if (!methodName.startsWith("set") || methodName.length() <= 3 || (types = method.getParameterTypes()).length != 1 || !map.containsKey(attrName = StrUtil.firstCharToLowerCase(methodName.substring(3)))) continue;
            try {
                String paraValue = MapTools.getString(map, attrName);
                Object value = paraValue != null ? converter.convert(types[0], paraValue) : null;
                method.invoke(bean, value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return bean;
    }
}

