/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.jsrv.core;

import com.ydn.jsrv.boot.JSrvBooter;
import com.ydn.jsrv.config.yaml.GlobalYamlConfiguration;
import com.ydn.jsrv.core.ActionMapping;
import com.ydn.jsrv.core.Config;
import com.ydn.jsrv.handler.ActionHandler;
import com.ydn.jsrv.handler.Handler;
import com.ydn.jsrv.handler.HandlerFactory;
import com.ydn.jsrv.plugin.IPlugin;
import com.ydn.jsrv.tool.upload.MultiUploadConfig;
import com.ydn.jsrv.util.LogUtil;
import java.util.List;
import javax.servlet.ServletContext;

public final class JSrv {
    private static final JSrv me = new JSrv();
    private ServletContext servletContext;
    private String contextPath = "";
    private Handler handler;
    private ActionMapping actionMapping;
    public static final String jsrvHome = "JSRV_HOME";

    private JSrv() {
    }

    public static JSrv me() {
        return me;
    }

    void init(JSrvBooter booter, ServletContext servletContext) {
        this.servletContext = servletContext;
        this.contextPath = servletContext.getContextPath();
        if (!GlobalYamlConfiguration.me().isBuilded()) {
            GlobalYamlConfiguration.me().buildPropFile();
        }
        Config.configJBooter(booter);
        this.initActionMapping();
        this.initHandler();
        this.initMultiUploadConfig();
        Config.startPlugins();
    }

    private void initHandler() {
        ActionHandler actionHandler = Config.getHandlers().getActionHandler();
        if (actionHandler == null) {
            actionHandler = new ActionHandler();
        }
        actionHandler.init(this.actionMapping);
        this.handler = HandlerFactory.getHandler(Config.getHandlers().getHandlerList(), actionHandler);
    }

    private void initActionMapping() {
        this.actionMapping = new ActionMapping(Config.getRoutes());
        this.actionMapping.buildActionMapping();
        Config.getRoutes().clear();
    }

    private void initMultiUploadConfig() {
        if (MultiUploadConfig.openUpload()) {
            MultiUploadConfig.init();
        }
    }

    void stopPlugins() {
        List<IPlugin> plugins = Config.getPlugins().getPluginList();
        if (plugins != null) {
            for (int i = plugins.size() - 1; i >= 0; --i) {
                boolean success = false;
                try {
                    success = plugins.get(i).stop();
                }
                catch (Exception e) {
                    success = false;
                    LogUtil.error(e.getMessage(), e);
                }
                if (success) continue;
                System.err.println("Plugin stop error: " + plugins.get(i).getClass().getName());
            }
        }
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public Handler getHandler() {
        return this.handler;
    }

    public ActionMapping getActionMapping() {
        return this.actionMapping;
    }
}

