/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.jsrv.core;

import com.ydn.jsrv.boot.JSrvBooter;
import com.ydn.jsrv.core.JSrv;
import com.ydn.jsrv.handler.Handler;
import com.ydn.jsrv.log.Log;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class JSrvFilter
implements Filter {
    private Handler handler;
    private String encoding;
    private JSrvBooter jSrvBooter;
    private static final JSrv jsrv = JSrv.me();
    private static Log log;
    private int contextPathLength;

    public JSrvFilter() {
        this.jSrvBooter = null;
    }

    public JSrvFilter(JSrvBooter jSrvBooter) {
        this.jSrvBooter = jSrvBooter;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        if (this.jSrvBooter == null) {
            this.createJSrvBooter(filterConfig.getInitParameter("booterClass"));
        }
        jsrv.init(this.jSrvBooter, filterConfig.getServletContext());
        String contextPath = filterConfig.getServletContext().getContextPath();
        this.contextPathLength = contextPath == null || "/".equals(contextPath) ? 0 : contextPath.length();
        this.encoding = "UTF-8";
        this.jSrvBooter.onStart();
        this.handler = jsrv.getHandler();
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        boolean[] isHandled;
        HttpServletResponse response;
        HttpServletRequest request;
        block5: {
            request = (HttpServletRequest)req;
            response = (HttpServletResponse)res;
            request.setCharacterEncoding(this.encoding);
            String target = request.getRequestURI();
            if (this.contextPathLength != 0) {
                target = target.substring(this.contextPathLength);
            }
            isHandled = new boolean[]{false};
            if (target.indexOf(".") > 0) {
                // empty if block
            }
            try {
                this.handler.handle(target, request, response, isHandled);
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block5;
                String qs = request.getQueryString();
                log.error(qs == null ? target : target + "?" + qs, e);
            }
        }
        if (!isHandled[0]) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    public void destroy() {
        this.handler = null;
        this.jSrvBooter.onStop();
        jsrv.stopPlugins();
    }

    protected void createJSrvBooter(String booterClass) {
        if (booterClass == null) {
            throw new RuntimeException("The booterClass parameter of JSrvFilter can not be blank");
        }
        try {
            Object temp = Class.forName(booterClass).newInstance();
            this.jSrvBooter = (JSrvBooter)temp;
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Can not create instance of class: " + booterClass, e);
        }
    }

    static void initLog() {
        log = Log.getLog(JSrvFilter.class);
    }
}

