/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.jsrv.doc;

import com.alibaba.fastjson.JSON;
import com.ydn.jsrv.annotation.ApiModelProperty;
import com.ydn.jsrv.annotation.RequestMapping;
import com.ydn.jsrv.annotation.RequestParam;
import com.ydn.jsrv.annotation.ResponseRet;
import com.ydn.jsrv.annotation.ResponseType;
import com.ydn.jsrv.core.Action;
import com.ydn.jsrv.core.ActionMapping;
import com.ydn.jsrv.core.JSrv;
import com.ydn.jsrv.handler.Handler;
import com.ydn.jsrv.plugin.activerecord.Model;
import com.ydn.jsrv.util.HandlerUtil;
import com.ydn.jsrv.util.Ret;
import com.ydn.jsrv.util.StrUtil;
import java.lang.reflect.Field;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DocHandler
extends Handler {
    private String url;
    private static final JSrv jsrv = JSrv.me();

    protected DocHandler(String url) {
        if (StrUtil.isBlank(url)) {
            throw new IllegalArgumentException("visitPath can not be blank");
        }
        if (!(url = url.trim()).startsWith("/")) {
            url = "/" + url;
        }
        this.url = url;
    }

    @Override
    public void handle(String target, HttpServletRequest request, HttpServletResponse response, boolean[] isHandled) {
        if (target.startsWith(this.url)) {
            isHandled[0] = true;
            ActionMapping actionMapping = jsrv.getActionMapping();
            if (target.equals(this.url)) {
                List<Map<String, String>> allActionKey = actionMapping.getAllActionKeys();
                HandlerUtil.render(request, response, JSON.toJSONString(allActionKey));
            } else {
                Action action = actionMapping.getAction(target = target.substring(this.url.length()));
                if (action == null) {
                    HandlerUtil.render(request, response, 404);
                    return;
                }
                RequestMapping requestMapping = action.getRequestMapping();
                HandlerUtil.render(request, response, JSON.toJSONString((Object)this.parseRequestMapping(requestMapping)));
            }
        } else {
            this.next.handle(target, request, response, isHandled);
        }
    }

    private Map parseRequestMapping(RequestMapping requestMapping) {
        HashMap<String, Object> mappingMap = new HashMap<String, Object>();
        mappingMap.put("name", requestMapping.name());
        mappingMap.put("method", requestMapping.method().name());
        RequestParam[] params = requestMapping.params();
        ArrayList paramsArr = new ArrayList();
        HashMap<String, Object> paramMap = null;
        if (params != null) {
            for (RequestParam requestParam : params) {
                paramMap = new HashMap<String, Object>();
                paramMap.put("code", requestParam.value());
                paramMap.put("name", requestParam.name());
                paramMap.put("type", requestParam.type().name());
                paramMap.put("desc", requestParam.desc());
                paramMap.put("required", requestParam.required());
                paramsArr.add(paramMap);
            }
        }
        mappingMap.put("requestParam", paramsArr);
        mappingMap.put("responseRet", this.parseResponseRet(requestMapping.resp()));
        mappingMap.put("responseDemo", this.generatorResponseDemo(requestMapping.resp()));
        return mappingMap;
    }

    private Map generatorResponseDemo(ResponseRet responseRet) {
        if (ResponseType.NONE.equals((Object)responseRet.type())) {
            String[] keys = responseRet.keys();
            Ret ret = Ret.ok();
            for (String key : keys) {
                String[] keyStr = key.split("\\|");
                if (keyStr.length > 1) {
                    ret.put(keyStr[0], (Object)"1");
                    continue;
                }
                ret.put(key, (Object)"1");
            }
            return ret;
        }
        HashMap map = new HashMap();
        Class respClass = responseRet.clazz();
        this.generatorFieldsDemo(map, respClass);
        if (ResponseType.OBJECT.equals((Object)responseRet.type())) {
            return Ret.ok(map);
        }
        if (ResponseType.LIST.equals((Object)responseRet.type())) {
            ArrayList list = new ArrayList();
            list.add(map);
            return Ret.ok(list);
        }
        return null;
    }

    private void generatorFieldsDemo(Map map, Class clazz) {
        Field[] fields;
        for (Field field : fields = clazz.getDeclaredFields()) {
            String varName = field.getName();
            if (field.getType() == String.class) {
                map.put(varName, "\u6d4b\u8bd5\u7528\u4f8b");
                continue;
            }
            if (field.getType() == Integer.class) {
                map.put(varName, "1001");
                continue;
            }
            if (field.getType() == Date.class) {
                map.put(varName, new Date());
                continue;
            }
            if (field.getType() == Timestamp.class) {
                map.put(varName, new Date());
                continue;
            }
            if (field.getType() == Object.class) {
                map.put(varName, new HashMap());
                continue;
            }
            if (field.getType() == List.class) {
                map.put(varName, new ArrayList());
                continue;
            }
            if (field.getType() != Map.class) continue;
            map.put(varName, new HashMap());
        }
    }

    private List<Map> parseResponseRet(ResponseRet responseRet) {
        ArrayList<Map> list = new ArrayList<Map>();
        HashMap<String, String> errorCodeMap = new HashMap<String, String>();
        errorCodeMap.put("name", "errcode");
        errorCodeMap.put("dataType", "String");
        errorCodeMap.put("desc", "0\u6210\u529f\uff0c1\u5931\u8d25\uff0c2\u672a\u767b\u5f55");
        list.add(errorCodeMap);
        HashMap<String, String> errorMsgMap = new HashMap<String, String>();
        errorMsgMap.put("name", "errmsg");
        errorMsgMap.put("dataType", "String");
        errorMsgMap.put("desc", "\u8fd4\u56de\u63d0\u793a\u4fe1\u606f\uff0c\u9ed8\u8ba4success");
        list.add(errorMsgMap);
        if (ResponseType.NONE.equals((Object)responseRet.type())) {
            String[] keys = responseRet.keys();
            HashMap<String, String> keyMap = null;
            for (String key : keys) {
                keyMap = new HashMap<String, String>();
                keyMap.put("dataType", "String");
                String[] keyStr = key.split("\\|");
                if (keyStr.length > 1) {
                    keyMap.put("name", keyStr[0]);
                    keyMap.put("desc", keyStr[1]);
                } else {
                    keyMap.put("name", key);
                    keyMap.put("desc", key);
                }
                list.add(keyMap);
            }
            return list;
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (ResponseType.OBJECT.equals((Object)responseRet.type())) {
            resultMap.put("name", "data");
            resultMap.put("dataType", "Object");
        }
        if (ResponseType.LIST.equals((Object)responseRet.type())) {
            resultMap.put("name", "list");
            resultMap.put("dataType", "Array");
        }
        Class respClass = responseRet.clazz();
        ArrayList<Map> fieldList = new ArrayList<Map>();
        this.parseFields(fieldList, respClass);
        resultMap.put("children", fieldList);
        list.add(resultMap);
        return list;
    }

    private void parseFields(List<Map> fieldList, Class clazz) {
        Field[] fields = clazz.getDeclaredFields();
        HashMap<String, String> map = null;
        for (Field field : fields) {
            String varName = field.getName();
            if (field.getAnnotation(ApiModelProperty.class) == null) continue;
            map = new HashMap<String, String>();
            map.put("name", varName);
            map.put("dataType", field.getType().getName());
            map.put("desc", field.getAnnotation(ApiModelProperty.class).value());
            fieldList.add(map);
        }
        Class superClass = clazz.getSuperclass();
        if (superClass != null && superClass != Model.class) {
            this.parseFields(fieldList, superClass);
        }
    }
}

