/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.jsrv.handler;

import com.ydn.jsrv.aop.Aop;
import com.ydn.jsrv.core.Action;
import com.ydn.jsrv.core.ActionMapping;
import com.ydn.jsrv.core.Controller;
import com.ydn.jsrv.core.ControllerFactory;
import com.ydn.jsrv.handler.Handler;
import com.ydn.jsrv.interceptor.Invocation;
import com.ydn.jsrv.render.RenderManager;
import com.ydn.jsrv.util.LogUtil;
import com.ydn.jsrv.util.StrUtil;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ActionHandler
extends Handler {
    protected ActionMapping actionMapping;
    protected static final RenderManager renderManager = RenderManager.me();
    protected ControllerFactory controllerFactory = new ControllerFactory();

    public void init(ActionMapping actionMapping) {
        this.actionMapping = actionMapping;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(String target, HttpServletRequest request, HttpServletResponse response, boolean[] isHandled) {
        if (target.indexOf(46) != -1) {
            return;
        }
        isHandled[0] = true;
        String indexHtml = this.actionMapping.getIndexHtml(target);
        if (!StrUtil.isBlank(indexHtml)) {
            renderManager.getRenderFactory().getRedirectRender(indexHtml).setContext(request, response).render();
            return;
        }
        Action action = this.actionMapping.getAction(target);
        if (action == null) {
            renderManager.getRenderFactory().getErrorRender(404).setContext(request, response).render();
            return;
        }
        Controller controller = null;
        try {
            controller = this.controllerFactory.getController(action.getControllerClass());
            Aop.inject(controller);
            controller.init(action, request, response);
            new Invocation(action, controller).invoke();
            controller.getRender().setContext(request, response).render();
        }
        catch (Exception e) {
            LogUtil.error("controller error  ", e);
            renderManager.getRenderFactory().getErrorRender(500).setContext(request, response).render();
        }
        finally {
            this.controllerFactory.recycle(controller);
        }
    }
}

