/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.jsrv.interceptor;

import com.ydn.jsrv.core.Action;
import com.ydn.jsrv.core.Controller;
import com.ydn.jsrv.interceptor.Interceptor;
import com.ydn.jsrv.proxy.Callback;
import com.ydn.jsrv.proxy.ProxyMethod;
import com.ydn.jsrv.proxy.ProxyMethodCache;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class Invocation {
    private static final Object[] NULL_ARGS = new Object[0];
    private Action action;
    private Object target;
    private Method method;
    private Object[] args;
    private Callback callback;
    private Interceptor[] inters;
    private Object returnValue;
    private int index = 0;

    public Invocation(Object target, Long proxyMethodKey, Callback callback, Object ... args) {
        this.action = null;
        this.target = target;
        ProxyMethod proxyMethod = ProxyMethodCache.get(proxyMethodKey);
        this.method = proxyMethod.getMethod();
        this.inters = proxyMethod.getInterceptors();
        this.callback = callback;
        this.args = args;
    }

    public Invocation(Object target, Long proxyMethodKey, Callback callback) {
        this.action = null;
        this.target = target;
        ProxyMethod proxyMethod = ProxyMethodCache.get(proxyMethodKey);
        this.method = proxyMethod.getMethod();
        this.inters = proxyMethod.getInterceptors();
        this.callback = callback;
    }

    public Invocation(Object target, Method method, Interceptor[] inters, Callback callback, Object[] args) {
        this.action = null;
        this.target = target;
        this.method = method;
        this.inters = inters;
        this.callback = callback;
        this.args = args;
    }

    protected Invocation() {
        this.action = null;
    }

    public Invocation(Action action, Controller controller) {
        this.action = action;
        this.inters = action.getInterceptors();
        this.target = controller;
    }

    public void invoke() {
        if (this.index < this.inters.length) {
            this.inters[this.index++].intercept(this);
        } else if (this.index++ == this.inters.length) {
            try {
                this.returnValue = this.action != null ? this.action.getMethod().invoke(this.target, this.args) : this.callback.call(this.args);
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getTargetException();
                if (t == null) {
                    t = e;
                }
                throw t instanceof RuntimeException ? (RuntimeException)t : new RuntimeException(t);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
    }

    public <T> T getTarget() {
        return (T)this.target;
    }

    public Method getMethod() {
        if (this.action != null) {
            return this.action.getMethod();
        }
        return this.method;
    }

    public String getMethodName() {
        if (this.action != null) {
            return this.action.getMethodName();
        }
        return this.method.getName();
    }

    public <T> T getReturnValue() {
        return (T)this.returnValue;
    }

    public void setReturnValue(Object returnValue) {
        this.returnValue = returnValue;
    }

    public Controller getController() {
        if (this.action == null) {
            throw new RuntimeException("This method can only be used for action interception");
        }
        return (Controller)this.target;
    }

    public String getActionKey() {
        if (this.action == null) {
            throw new RuntimeException("This method can only be used for action interception");
        }
        return this.action.getActionKey();
    }

    public boolean isActionInvocation() {
        return this.action != null;
    }
}

