/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.jsrv.interceptor;

import com.ydn.jsrv.interceptor.Interceptor;
import com.ydn.jsrv.interceptor.Invocation;
import com.ydn.jsrv.plugin.monitor.Monitor;
import com.ydn.jsrv.plugin.monitor.MonitorDataMap;
import com.ydn.jsrv.plugin.monitor.MonitorFactory;
import com.ydn.jsrv.util.ExceptionUtils;
import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

public class MonitorInterceptor
implements Interceptor {
    private MonitorFactory monitorFactory = new MonitorFactory();
    private final ConcurrentMap<String, AtomicInteger> concurrents = new ConcurrentHashMap<String, AtomicInteger>();

    @Override
    public void intercept(Invocation inv) {
        long startTime = new Date().getTime();
        boolean success = true;
        String errorInfo = "";
        try {
            this.getConcurrent(inv.getActionKey()).incrementAndGet();
            inv.invoke();
        }
        catch (Exception e) {
            success = false;
            errorInfo = ExceptionUtils.getExceptionStack(e);
            throw e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e);
        }
        finally {
            long endTime = new Date().getTime();
            this.collect(inv.getActionKey(), startTime, endTime, success, errorInfo);
            this.getConcurrent(inv.getActionKey()).decrementAndGet();
        }
    }

    private void collect(String actionKey, long startTime, long endTime, boolean sucess, String errorInfo) {
        MonitorDataMap monitorDataMap = new MonitorDataMap();
        int concurrent = this.getConcurrent(actionKey).get();
        monitorDataMap.addParameter("path", actionKey).addParameter("success", String.valueOf(sucess ? 1 : 0)).addParameter("failure", String.valueOf(sucess ? 0 : 1)).addParameter("elapsed", String.valueOf(endTime - startTime)).addParameter("concurrent", String.valueOf(concurrent));
        Monitor monitor = this.monitorFactory.getMonitor(monitorDataMap);
        if (monitor == null) {
            return;
        }
        monitor.collect(monitorDataMap);
    }

    private AtomicInteger getConcurrent(String key) {
        AtomicInteger concurrent = (AtomicInteger)this.concurrents.get(key);
        if (concurrent == null) {
            this.concurrents.putIfAbsent(key, new AtomicInteger());
            concurrent = (AtomicInteger)this.concurrents.get(key);
        }
        return concurrent;
    }
}

