/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.jsrv.interceptor;

import com.ydn.jsrv.annotation.RequestMethod;
import com.ydn.jsrv.annotation.RequestParam;
import com.ydn.jsrv.core.Controller;
import com.ydn.jsrv.interceptor.Interceptor;
import com.ydn.jsrv.interceptor.Invocation;
import com.ydn.jsrv.util.Ret;
import java.util.HashMap;
import java.util.Map;

public class RequestMappingInterceptor
implements Interceptor {
    @Override
    public void intercept(Invocation inv) {
        Controller controller = inv.getController();
        RequestMethod _requestMethod = controller.getAction().getMethonType();
        String requestMethon = controller.getRequest().getMethod();
        if (!_requestMethod.name().equals(requestMethon)) {
            controller.renderJson(Ret.error("RequestMethod need " + _requestMethod.name()));
            return;
        }
        Map map = this.validateRequestParam(controller);
        if (map.isEmpty()) {
            inv.invoke();
        } else {
            controller.renderJson(Ret.error(map));
        }
    }

    protected Map validateRequestParam(Controller controller) {
        HashMap<String, String> errorMap = new HashMap<String, String>();
        RequestParam[] params = controller.getAction().getRequestParam();
        if (params == null) {
            return errorMap;
        }
        for (RequestParam param : params) {
            if (!param.required() || this.validateRequired(controller, param.value())) continue;
            errorMap.put(param.value(), param.tips());
        }
        return errorMap;
    }

    protected boolean validateRequired(Controller controller, String field) {
        String value = controller.getPara(field);
        return value != null && !"".equals(value);
    }
}

