/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.jsrv.plugin.activerecord;

import com.ydn.jsrv.plugin.activerecord.ActiveRecordException;
import com.ydn.jsrv.plugin.activerecord.IContainerFactory;
import com.ydn.jsrv.plugin.activerecord.IDbProFactory;
import com.ydn.jsrv.plugin.activerecord.SqlReporter;
import com.ydn.jsrv.plugin.activerecord.dialect.Dialect;
import com.ydn.jsrv.plugin.activerecord.dialect.MysqlDialect;
import com.ydn.jsrv.util.LogUtil;
import com.ydn.jsrv.util.StrUtil;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;

public class Config {
    private final ThreadLocal<Connection> threadLocal = new ThreadLocal();
    String name;
    DataSource dataSource;
    Dialect dialect;
    boolean showSql;
    int transactionLevel;
    IContainerFactory containerFactory;
    IDbProFactory dbProFactory = IDbProFactory.defaultDbProFactory;

    Config(String name, DataSource dataSource, int transactionLevel) {
        this.init(name, dataSource, new MysqlDialect(), false, transactionLevel, IContainerFactory.defaultContainerFactory);
    }

    private void init(String name, DataSource dataSource, Dialect dialect, boolean showSql, int transactionLevel, IContainerFactory containerFactory) {
        if (StrUtil.isBlank(name)) {
            throw new IllegalArgumentException("Config name can not be blank");
        }
        if (dialect == null) {
            throw new IllegalArgumentException("Dialect can not be null");
        }
        if (containerFactory == null) {
            throw new IllegalArgumentException("ContainerFactory can not be null");
        }
        this.name = name.trim();
        this.dataSource = dataSource;
        this.dialect = dialect;
        this.showSql = showSql;
        this.setTransactionLevel(transactionLevel);
        this.containerFactory = containerFactory;
    }

    public Config(String name, DataSource dataSource) {
        this(name, dataSource, new MysqlDialect());
    }

    public Config(String name, DataSource dataSource, Dialect dialect) {
        this.init(name, dataSource, dialect, false, 4, IContainerFactory.defaultContainerFactory);
    }

    private Config() {
    }

    void setTransactionLevel(int transactionLevel) {
        int t = transactionLevel;
        if (t != 0 && t != 1 && t != 2 && t != 4 && t != 8) {
            throw new IllegalArgumentException("The transactionLevel only be 0, 1, 2, 4, 8");
        }
        this.transactionLevel = transactionLevel;
    }

    public static Config createBrokenConfig() {
        Config ret = new Config();
        ret.dialect = new MysqlDialect();
        ret.showSql = false;
        ret.transactionLevel = 4;
        ret.containerFactory = IContainerFactory.defaultContainerFactory;
        return ret;
    }

    public String getName() {
        return this.name;
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    public int getTransactionLevel() {
        return this.transactionLevel;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public IContainerFactory getContainerFactory() {
        return this.containerFactory;
    }

    public IDbProFactory getDbProFactory() {
        return this.dbProFactory;
    }

    public boolean isShowSql() {
        return this.showSql;
    }

    public void setThreadLocalConnection(Connection connection) {
        this.threadLocal.set(connection);
    }

    public void removeThreadLocalConnection() {
        this.threadLocal.remove();
    }

    public Connection getConnection() throws SQLException {
        Connection conn = this.threadLocal.get();
        if (conn != null) {
            return conn;
        }
        return this.showSql ? new SqlReporter(this.dataSource.getConnection()).getConnection() : this.dataSource.getConnection();
    }

    public Connection getThreadLocalConnection() {
        return this.threadLocal.get();
    }

    public boolean isInTransaction() {
        return this.threadLocal.get() != null;
    }

    public void close(ResultSet rs, Statement st, Connection conn) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                LogUtil.error(e.getMessage(), e);
            }
        }
        if (st != null) {
            try {
                st.close();
            }
            catch (SQLException e) {
                LogUtil.error(e.getMessage(), e);
            }
        }
        if (this.threadLocal.get() == null && conn != null) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                throw new ActiveRecordException(e);
            }
        }
    }

    public void close(Statement st, Connection conn) {
        if (st != null) {
            try {
                st.close();
            }
            catch (SQLException e) {
                LogUtil.error(e.getMessage(), e);
            }
        }
        if (this.threadLocal.get() == null && conn != null) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                throw new ActiveRecordException(e);
            }
        }
    }

    public void close(Connection conn) {
        if (this.threadLocal.get() == null && conn != null) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                throw new ActiveRecordException(e);
            }
        }
    }
}

