/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.jsrv.plugin.activerecord;

import com.ydn.jsrv.interceptor.Interceptor;
import com.ydn.jsrv.interceptor.Invocation;
import com.ydn.jsrv.plugin.activerecord.DbKit;
import com.ydn.jsrv.util.LogUtil;
import java.sql.Connection;

public class OneConnectionPerThread
implements Interceptor {
    @Override
    public void intercept(Invocation inv) {
        Connection conn = DbKit.config.getThreadLocalConnection();
        if (conn != null) {
            inv.invoke();
            return;
        }
        try {
            conn = DbKit.config.getConnection();
            DbKit.config.setThreadLocalConnection(conn);
            inv.invoke();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            DbKit.config.removeThreadLocalConnection();
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception e) {
                    LogUtil.error(e.getMessage(), e);
                }
            }
        }
    }
}

