/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.jsrv.plugin.activerecord;

import com.ydn.jsrv.plugin.activerecord.Model;
import com.ydn.jsrv.util.StrUtil;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class Table {
    private String name;
    private String[] primaryKey = null;
    private Map<String, Class<?>> columnTypeMap;
    private String source;
    private Class<? extends Model<?>> modelClass;

    public Table(String name, Class<? extends Model<?>> modelClass) {
        if (StrUtil.isBlank(name)) {
            throw new IllegalArgumentException("Table name can not be blank.");
        }
        if (modelClass == null) {
            throw new IllegalArgumentException("Model class can not be null.");
        }
        this.name = name.trim();
        this.modelClass = modelClass;
    }

    public Table(String name, String primaryKey, Class<? extends Model<?>> modelClass) {
        if (StrUtil.isBlank(name)) {
            throw new IllegalArgumentException("Table name can not be blank.");
        }
        if (StrUtil.isBlank(primaryKey)) {
            throw new IllegalArgumentException("Primary key can not be blank.");
        }
        if (modelClass == null) {
            throw new IllegalArgumentException("Model class can not be null.");
        }
        this.name = name.trim();
        this.setPrimaryKey(primaryKey.trim());
        this.modelClass = modelClass;
    }

    void setPrimaryKey(String primaryKey) {
        String[] arr = primaryKey.split(",");
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = arr[i].trim();
        }
        this.primaryKey = arr;
    }

    void setColumnTypeMap(Map<String, Class<?>> columnTypeMap) {
        if (columnTypeMap == null) {
            throw new IllegalArgumentException("columnTypeMap can not be null");
        }
        this.columnTypeMap = columnTypeMap;
    }

    public String getName() {
        return this.name;
    }

    void setColumnType(String columnLabel, Class<?> columnType) {
        this.columnTypeMap.put(columnLabel, columnType);
    }

    public Class<?> getColumnType(String columnLabel) {
        return this.columnTypeMap.get(columnLabel);
    }

    public boolean hasColumnLabel(String columnLabel) {
        return this.columnTypeMap.containsKey(columnLabel);
    }

    public String[] getPrimaryKey() {
        return this.primaryKey;
    }

    public Class<? extends Model<?>> getModelClass() {
        return this.modelClass;
    }

    public Map<String, Class<?>> getColumnTypeMap() {
        return Collections.unmodifiableMap(this.columnTypeMap);
    }

    public Set<Map.Entry<String, Class<?>>> getColumnTypeMapEntrySet() {
        return Collections.unmodifiableSet(this.columnTypeMap.entrySet());
    }

    public Set<String> getColumnNameSet() {
        return Collections.unmodifiableSet(this.columnTypeMap.keySet());
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }
}

